/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.proximity;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.texboobcat.pufferLike.proximity.ProximityService;

public class ProximityListener
implements Listener {
    private final Plugin plugin;
    private final ProximityService proximity;

    public ProximityListener(Plugin plugin, ProximityService proximity) {
        this.plugin = plugin;
        this.proximity = proximity;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        this.proximity.addPlayer(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent e) {
        this.proximity.removePlayer(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        this.proximity.addOrMove(p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        this.proximity.addOrMove(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.proximity.addOrMove(e.getPlayer());
    }
}

