/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.proximity;

import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProximityService {
    private final Plugin plugin;
    private final int cellSize;
    private final double moveThresholdSq;
    private final int neighborRadiusCells;
    private final boolean crossWorld;
    private final ConcurrentMap<UUID, ConcurrentMap<CellKey, Set<UUID>>> worldGrid = new ConcurrentHashMap<UUID, ConcurrentMap<CellKey, Set<UUID>>>();
    private final ConcurrentMap<UUID, Tracked> trackedPlayers = new ConcurrentHashMap<UUID, Tracked>();

    public ProximityService(Plugin plugin, FileConfiguration cfg) {
        this.plugin = plugin;
        this.cellSize = Math.max(8, cfg.getInt("proximity.cell-size", 32));
        double moveThreshold = cfg.getDouble("proximity.move-threshold", 1.25);
        this.moveThresholdSq = Math.max(0.0, moveThreshold * moveThreshold);
        this.neighborRadiusCells = Math.max(0, cfg.getInt("proximity.neighbor-radius-cells", 2));
        this.crossWorld = cfg.getBoolean("proximity.track-cross-world", false);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.addPlayer(p);
        }
    }

    public void shutdown() {
        this.worldGrid.clear();
        this.trackedPlayers.clear();
    }

    public void addOrMove(Player player) {
        if (!player.isOnline()) {
            return;
        }
        UUID puid = player.getUniqueId();
        Location loc = player.getLocation();
        UUID worldId = loc.getWorld().getUID();
        CellKey key = this.cellFor(loc);
        Tracked prev = (Tracked)this.trackedPlayers.get(puid);
        if (prev != null && prev.worldId.equals(worldId) && prev.cell.equals(key) && prev.lastLocation != null && prev.lastLocation.distanceSquared(loc) < this.moveThresholdSq) {
            return;
        }
        if (prev != null) {
            this.removeFromCell(puid, prev.worldId, prev.cell);
        }
        this.worldGrid.computeIfAbsent(worldId, w -> new ConcurrentHashMap()).computeIfAbsent(key, k -> ConcurrentHashMap.newKeySet()).add(puid);
        this.trackedPlayers.put(puid, new Tracked(worldId, key, loc.clone()));
    }

    public void addPlayer(Player player) {
        this.addOrMove(player);
    }

    public void removePlayer(Player player) {
        UUID puid = player.getUniqueId();
        Tracked prev = (Tracked)this.trackedPlayers.remove(puid);
        if (prev != null) {
            this.removeFromCell(puid, prev.worldId, prev.cell);
        }
    }

    private void removeFromCell(UUID playerId, UUID worldId, CellKey cell) {
        ConcurrentMap grid = (ConcurrentMap)this.worldGrid.get(worldId);
        if (grid == null) {
            return;
        }
        Set set = (Set)grid.get(cell);
        if (set != null) {
            set.remove(playerId);
            if (set.isEmpty()) {
                grid.remove(cell);
            }
        }
        if (grid.isEmpty()) {
            this.worldGrid.remove(worldId);
        }
    }

    public OptionalDouble nearestPlayerDistance(Entity entity) {
        return this.nearestPlayerDistance(entity.getLocation());
    }

    public OptionalDouble nearestPlayerDistance(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return OptionalDouble.empty();
        }
        UUID worldId = world.getUID();
        double bestSq = Double.POSITIVE_INFINITY;
        UUID bestPlayer = null;
        ArrayList<UUID> worldsToSearch = new ArrayList<UUID>();
        worldsToSearch.add(worldId);
        if (this.crossWorld) {
            for (World w : Bukkit.getWorlds()) {
                if (w.getUID().equals(worldId)) continue;
                worldsToSearch.add(w.getUID());
            }
        }
        int cx = this.floorDiv(loc.getBlockX(), this.cellSize);
        int cz = this.floorDiv(loc.getBlockZ(), this.cellSize);
        for (UUID wid : worldsToSearch) {
            ConcurrentMap grid = (ConcurrentMap)this.worldGrid.get(wid);
            if (grid == null) continue;
            for (int dx = -this.neighborRadiusCells; dx <= this.neighborRadiusCells; ++dx) {
                for (int dz = -this.neighborRadiusCells; dz <= this.neighborRadiusCells; ++dz) {
                    CellKey key = new CellKey(cx + dx, cz + dz);
                    Set set = (Set)grid.get(key);
                    if (set == null || set.isEmpty()) continue;
                    for (UUID puid : set) {
                        double dsq;
                        Player p = Bukkit.getPlayer((UUID)puid);
                        if (p == null || !p.isOnline() || !this.crossWorld && p.getWorld() != world || !((dsq = p.getLocation().distanceSquared(loc)) < bestSq)) continue;
                        bestSq = dsq;
                        bestPlayer = puid;
                    }
                }
            }
        }
        if (bestPlayer == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.sqrt(bestSq));
    }

    public int onlinePlayersInNeighborCells(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return 0;
        }
        UUID worldId = world.getUID();
        int cx = this.floorDiv(loc.getBlockX(), this.cellSize);
        int cz = this.floorDiv(loc.getBlockZ(), this.cellSize);
        ConcurrentMap grid = (ConcurrentMap)this.worldGrid.get(worldId);
        if (grid == null) {
            return 0;
        }
        int count = 0;
        for (int dx = -this.neighborRadiusCells; dx <= this.neighborRadiusCells; ++dx) {
            for (int dz = -this.neighborRadiusCells; dz <= this.neighborRadiusCells; ++dz) {
                Set set = (Set)grid.get(new CellKey(cx + dx, cz + dz));
                if (set == null) continue;
                count += set.size();
            }
        }
        return count;
    }

    private CellKey cellFor(Location loc) {
        return new CellKey(this.floorDiv(loc.getBlockX(), this.cellSize), this.floorDiv(loc.getBlockZ(), this.cellSize));
    }

    private int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    private static final class CellKey {
        final int cx;
        final int cz;

        private CellKey(int cx, int cz) {
            this.cx = cx;
            this.cz = cz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellKey cellKey = (CellKey)o;
            return this.cx == cellKey.cx && this.cz == cellKey.cz;
        }

        public int hashCode() {
            return Objects.hash(this.cx, this.cz);
        }

        public String toString() {
            return "CellKey{" + this.cx + "," + this.cz + "}";
        }
    }

    private record Tracked(UUID worldId, CellKey cell, Location lastLocation) {
    }
}

