/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.smoothing;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class BlockSmootherListener
implements Listener {
    private final FileConfiguration cfg;
    private final TickService ticks;
    private final StatsService stats;
    private final Map<Block, Long> lastUpdateTick = new WeakHashMap<Block, Long>();

    public BlockSmootherListener(FileConfiguration cfg, TickService ticks, StatsService stats) {
        this.cfg = cfg;
        this.ticks = ticks;
        this.stats = stats;
    }

    private boolean shouldSmooth(Block block) {
        int cooldown = this.cfg.getInt("blocks.physics-cooldown-ticks", 0);
        if (cooldown <= 0) {
            return false;
        }
        long now = this.ticks.currentTick();
        long min = Math.max(1, cooldown);
        Long last = this.lastUpdateTick.get(block);
        if (last != null && now - last < min) {
            return true;
        }
        this.lastUpdateTick.put(block, now);
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent e) {
        if (this.shouldSmooth(e.getBlock())) {
            e.setCancelled(true);
            this.stats.increment("blockPhysicsSmoothed");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onRedstone(BlockRedstoneEvent e) {
        if (this.shouldSmooth(e.getBlock())) {
            e.setNewCurrent(e.getOldCurrent());
            this.stats.increment("redstoneSmoothed");
        }
    }
}

