/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.smoothing;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class PistonSmootherListener
implements Listener {
    private final FileConfiguration cfg;
    private final TickService ticks;
    private final StatsService stats;
    private long lastTick = -1L;
    private int opsThisTick = 0;

    public PistonSmootherListener(FileConfiguration cfg, TickService ticks, StatsService stats) {
        this.cfg = cfg;
        this.ticks = ticks;
        this.stats = stats;
    }

    private boolean allowOne() {
        int limit = Math.max(0, this.cfg.getInt("blocks.pistons.limit-per-tick", 0));
        if (limit <= 0) {
            return true;
        }
        long now = this.ticks.currentTick();
        if (now != this.lastTick) {
            this.lastTick = now;
            this.opsThisTick = 0;
        }
        if (this.opsThisTick >= limit) {
            return false;
        }
        ++this.opsThisTick;
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExtend(BlockPistonExtendEvent e) {
        if (!this.allowOne()) {
            e.setCancelled(true);
            this.stats.increment("pistonsLimited");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onRetract(BlockPistonRetractEvent e) {
        if (!this.allowOne()) {
            e.setCancelled(true);
            this.stats.increment("pistonsLimited");
        }
    }
}

