/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.smoothing;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class WorldSmootherListener
implements Listener {
    private final FileConfiguration cfg;
    private final TickService ticks;
    private final ProximityService proximity;
    private final StatsService stats;
    private final Map<Block, Long> fluidCooldown = new WeakHashMap<Block, Long>();

    public WorldSmootherListener(FileConfiguration cfg, TickService ticks, ProximityService proximity, StatsService stats) {
        this.cfg = cfg;
        this.ticks = ticks;
        this.proximity = proximity;
        this.stats = stats;
    }

    private boolean isFar(Block b) {
        double minDist = Math.max(64.0, this.cfg.getDouble("spawns.far-deny.min-player-dist", 96.0));
        Location loc = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 0.5, (double)b.getZ() + 0.5);
        double d = this.proximity.nearestPlayerDistance(loc).orElse(Double.POSITIVE_INFINITY);
        return d > minDist || d < 0.0;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFluid(BlockFromToEvent e) {
        if (!this.cfg.getBoolean("blocks.throttle-fluids", true)) {
            return;
        }
        Block src = e.getBlock();
        int cooldown = Math.max(1, this.cfg.getInt("blocks.physics-cooldown-ticks", 3));
        long now = this.ticks.currentTick();
        Long last = this.fluidCooldown.get(src);
        if (last != null && now - last < (long)cooldown) {
            e.setCancelled(true);
            this.stats.increment("fluidsThrottled");
            return;
        }
        this.fluidCooldown.put(src, now);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLeaves(LeavesDecayEvent e) {
        String mode = this.cfg.getString("blocks.leaves-decay", "defer_far");
        if (!"defer_far".equalsIgnoreCase(mode)) {
            return;
        }
        if (this.isFar(e.getBlock())) {
            e.setCancelled(true);
            this.stats.increment("leavesDeferred");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onGrow(BlockGrowEvent e) {
        String mode = this.cfg.getString("blocks.plant-growth", "defer_far");
        if (!"defer_far".equalsIgnoreCase(mode)) {
            return;
        }
        if (this.isFar(e.getBlock())) {
            e.setCancelled(true);
            this.stats.increment("growthDeferred");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onStructure(StructureGrowEvent e) {
        String mode = this.cfg.getString("blocks.plant-growth", "defer_far");
        if (!"defer_far".equalsIgnoreCase(mode)) {
            return;
        }
        Block base = e.getLocation().getBlock();
        if (this.isFar(base)) {
            e.setCancelled(true);
            this.stats.increment("growthDeferred");
        }
    }
}

