/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.spawns;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Golem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class SpawnControllerListener
implements Listener {
    private final FileConfiguration cfg;
    private final ProximityService proximity;
    private final StatsService stats;

    public SpawnControllerListener(FileConfiguration cfg, ProximityService proximity, StatsService stats) {
        this.cfg = cfg;
        this.proximity = proximity;
        this.stats = stats;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreCreatureSpawn(PreCreatureSpawnEvent e) {
        int count;
        int cap;
        String cat;
        if (!this.cfg.getBoolean("spawns.enabled", true)) {
            return;
        }
        if (this.cfg.getBoolean("spawns.tps-guard.enabled", true)) {
            double threshold = this.cfg.getDouble("spawns.tps-guard.threshold", 18.5);
            double tps = this.currentTPS1m();
            if (tps < threshold) {
                double denialPercent = Math.max(0.0, Math.min(1.0, this.cfg.getDouble("spawns.tps-guard.denial-percent", 0.35)));
                if (Math.random() < denialPercent) {
                    e.setShouldAbortSpawn(true);
                    this.stats.increment("spawnsDenied");
                    return;
                }
            }
        }
        if (this.cfg.getBoolean("spawns.far-deny.enabled", true)) {
            double minDist = this.cfg.getDouble("spawns.far-deny.min-player-dist", 96.0);
            double dist = this.proximity.nearestPlayerDistance(e.getSpawnLocation()).orElse(Double.POSITIVE_INFINITY);
            if (dist > minDist) {
                e.setShouldAbortSpawn(true);
                this.stats.increment("spawnsDenied");
                return;
            }
        }
        Chunk chunk = e.getSpawnLocation().getChunk();
        switch (cat = this.categoryOf(e.getType())) {
            case "MONSTER": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.MONSTER", 70);
                break;
            }
            case "CREATURE": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.CREATURE", 50);
                break;
            }
            case "WATER_AMBIENT": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.WATER_AMBIENT", 30);
                break;
            }
            default: {
                int n = cap = Integer.MAX_VALUE;
            }
        }
        if (cap != Integer.MAX_VALUE && (count = this.countCategoryInChunk(chunk, cat)) >= cap) {
            e.setShouldAbortSpawn(true);
            this.stats.increment("spawnsDenied");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        int count;
        int cap;
        String cat;
        if (!this.cfg.getBoolean("spawns.enabled", true)) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (this.cfg.getBoolean("spawns.tps-guard.enabled", true)) {
            double threshold = this.cfg.getDouble("spawns.tps-guard.threshold", 18.5);
            double tps = this.currentTPS1m();
            if (tps < threshold) {
                double denialPercent = Math.max(0.0, Math.min(1.0, this.cfg.getDouble("spawns.tps-guard.denial-percent", 0.35)));
                if (Math.random() < denialPercent) {
                    e.setCancelled(true);
                    this.stats.increment("spawnsDenied");
                    return;
                }
            }
        }
        if (this.cfg.getBoolean("spawns.far-deny.enabled", true)) {
            double minDist = this.cfg.getDouble("spawns.far-deny.min-player-dist", 96.0);
            double dist = this.proximity.nearestPlayerDistance((Entity)entity).orElse(Double.POSITIVE_INFINITY);
            if (dist > minDist) {
                e.setCancelled(true);
                this.stats.increment("spawnsDenied");
                return;
            }
        }
        Chunk chunk = entity.getLocation().getChunk();
        switch (cat = this.categoryOf((Entity)entity)) {
            case "MONSTER": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.MONSTER", 70);
                break;
            }
            case "CREATURE": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.CREATURE", 50);
                break;
            }
            case "WATER_AMBIENT": {
                int n = this.cfg.getInt("spawns.per-chunk-soft-cap.WATER_AMBIENT", 30);
                break;
            }
            default: {
                int n = cap = Integer.MAX_VALUE;
            }
        }
        if (cap != Integer.MAX_VALUE && (count = this.countCategoryInChunk(chunk, cat)) >= cap) {
            e.setCancelled(true);
            this.stats.increment("spawnsDenied");
        }
    }

    private int countCategoryInChunk(Chunk chunk, String cat) {
        int c = 0;
        for (Entity ent : chunk.getEntities()) {
            LivingEntity le;
            if (!(ent instanceof LivingEntity) || !this.categoryOf((Entity)(le = (LivingEntity)ent)).equals(cat)) continue;
            ++c;
        }
        return c;
    }

    private String categoryOf(Entity e) {
        if (e instanceof Monster) {
            return "MONSTER";
        }
        if (e instanceof Animals || e instanceof Golem || e instanceof Villager || e instanceof Ambient) {
            return "CREATURE";
        }
        if (e instanceof WaterMob) {
            return "WATER_AMBIENT";
        }
        return "OTHER";
    }

    private String categoryOf(EntityType type) {
        if (Monster.class.isAssignableFrom(type.getEntityClass())) {
            return "MONSTER";
        }
        if (Animals.class.isAssignableFrom(type.getEntityClass()) || Golem.class.isAssignableFrom(type.getEntityClass()) || Villager.class.isAssignableFrom(type.getEntityClass()) || Ambient.class.isAssignableFrom(type.getEntityClass())) {
            return "CREATURE";
        }
        if (WaterMob.class.isAssignableFrom(type.getEntityClass())) {
            return "WATER_AMBIENT";
        }
        return "OTHER";
    }

    private double currentTPS1m() {
        try {
            double[] tps = Bukkit.getServer().getTPS();
            if (tps != null && tps.length > 0) {
                return tps[1 >= tps.length ? tps.length - 1 : 1];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 20.0;
    }
}

