/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.telemetry;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public class StatsService {
    private final ConcurrentHashMap<String, LongAdder> counters = new ConcurrentHashMap();

    public void increment(String key) {
        this.counters.computeIfAbsent(key, k -> new LongAdder()).increment();
    }

    public long get(String key) {
        LongAdder a = this.counters.get(key);
        return a == null ? 0L : a.sum();
    }

    public Map<String, Long> snapshot() {
        ConcurrentHashMap snap = new ConcurrentHashMap();
        this.counters.forEach((k, v) -> snap.put(k, v.sum()));
        return Collections.unmodifiableMap(snap);
    }
}

