/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.texboobcat.pufferLike.async.WorkerPool;

public class StressTester {
    private final Plugin plugin;
    private final WorkerPool workerPool;
    private final Set<UUID> spawned = ConcurrentHashMap.newKeySet();
    private final Map<String, BukkitTask> runningTasks = new HashMap<String, BukkitTask>();
    private final Map<UUID, Location> moveOriginal = new ConcurrentHashMap<UUID, Location>();

    public StressTester(Plugin plugin, WorkerPool workerPool) {
        this.plugin = plugin;
        this.workerPool = workerPool;
    }

    public boolean hasRunning(String key) {
        return this.runningTasks.containsKey(key);
    }

    public void stop(String key) {
        BukkitTask t = this.runningTasks.remove(key);
        if (t != null) {
            t.cancel();
        }
        if (key.equals("ai") || key.equals("dab-bands") || key.equals("vis-dense")) {
            this.cleanupSpawned();
        }
        if (key.equals("move")) {
            for (Map.Entry<UUID, Location> e : new ArrayList<Map.Entry<UUID, Location>>(this.moveOriginal.entrySet())) {
                UUID id = e.getKey();
                Location back = e.getValue();
                Player p = Bukkit.getPlayer((UUID)id);
                if (p != null && p.isOnline()) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> p.teleport(back));
                }
                this.moveOriginal.remove(id);
            }
        }
    }

    public void stopAll() {
        for (BukkitTask t : this.runningTasks.values()) {
            t.cancel();
        }
        this.runningTasks.clear();
        this.cleanupSpawned();
    }

    private void cleanupSpawned() {
        if (this.spawned.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            for (World w : Bukkit.getWorlds()) {
                for (Entity e : w.getEntities()) {
                    if (!this.spawned.contains(e.getUniqueId())) continue;
                    e.remove();
                }
            }
            this.spawned.clear();
        });
    }

    public void startAiSwarm(Player target, EntityType type, int count, int seconds, double radius) {
        this.stop("ai");
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Location base = target.getLocation();
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            int spawnedNow = 0;
            for (int i = 0; i < count; ++i) {
                double ang = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                double dist = ThreadLocalRandom.current().nextDouble(radius * 0.5, radius);
                Location at = base.clone().add(Math.cos(ang) * dist, 0.0, Math.sin(ang) * dist);
                at = world.getHighestBlockAt(at).getLocation().add(0.5, 1.0, 0.5);
                try {
                    Entity e = world.spawnEntity(at, type, false);
                    this.spawned.add(e.getUniqueId());
                    ++spawnedNow;
                    if (!(e instanceof Mob)) continue;
                    Mob mob = (Mob)e;
                    mob.setTarget((LivingEntity)target);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            target.sendMessage("\u00a7e[stress]\u00a77 AI swarm spawned: \u00a7b" + spawnedNow + "\u00a77 of type \u00a7b" + String.valueOf(type));
        });
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            Player p = target;
            if (!p.isOnline()) {
                return;
            }
            for (World w : Bukkit.getWorlds()) {
                for (Entity e : w.getEntities()) {
                    Mob mob;
                    if (!this.spawned.contains(e.getUniqueId()) || !(e instanceof Mob) || (mob = (Mob)e).isDead() || mob.getTarget() != null && mob.getTarget().equals((Object)p)) continue;
                    mob.setTarget((LivingEntity)p);
                }
            }
        }, 40L, 40L);
        this.runningTasks.put("ai", task);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.stop("ai"), (long)seconds * 20L);
    }

    public void startParticleBursts(final Player center, final int bursts, final int perBurst, final double radius, int periodTicks) {
        this.stop("particles");
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, new Runnable(){
            int remaining;
            {
                this.remaining = bursts;
            }

            @Override
            public void run() {
                if (this.remaining-- <= 0) {
                    StressTester.this.stop("particles");
                    return;
                }
                World w = center.getWorld();
                if (w == null) {
                    return;
                }
                Location base = center.getLocation();
                for (int i = 0; i < perBurst; ++i) {
                    double ang = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                    double r = ThreadLocalRandom.current().nextDouble(0.0, radius);
                    double x = base.getX() + Math.cos(ang) * r;
                    double z = base.getZ() + Math.sin(ang) * r;
                    double y = base.getY() + ThreadLocalRandom.current().nextDouble(0.0, 2.0);
                    try {
                        w.spawnParticle(Particle.CRIT, x, y, z, 20, 0.2, 0.2, 0.2, 0.01);
                        w.spawnParticle(Particle.SMOKE, x, y, z, 10, 0.2, 0.2, 0.2, 0.01);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, 1L, (long)Math.max(1, periodTicks));
        this.runningTasks.put("particles", task);
    }

    public void startSoundBursts(final Player center, final int bursts, final int perBurst, final double radius, int periodTicks) {
        this.stop("sounds");
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, new Runnable(){
            int remaining;
            final Sound[] pool;
            {
                this.remaining = bursts;
                this.pool = new Sound[]{Sound.ENTITY_ARROW_HIT_PLAYER, Sound.ENTITY_ZOMBIE_AMBIENT, Sound.BLOCK_ANVIL_LAND};
            }

            @Override
            public void run() {
                if (this.remaining-- <= 0) {
                    StressTester.this.stop("sounds");
                    return;
                }
                World w = center.getWorld();
                if (w == null) {
                    return;
                }
                Location base = center.getLocation();
                for (int i = 0; i < perBurst; ++i) {
                    double ang = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                    double r = ThreadLocalRandom.current().nextDouble(0.0, radius);
                    double x = base.getX() + Math.cos(ang) * r;
                    double z = base.getZ() + Math.sin(ang) * r;
                    double y = base.getY();
                    Sound s = this.pool[ThreadLocalRandom.current().nextInt(this.pool.length)];
                    try {
                        w.playSound(new Location(w, x, y, z), s, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, 1L, (long)Math.max(1, periodTicks));
        this.runningTasks.put("sounds", task);
    }

    public void startDabBands(Player target, EntityType type, int perBand, int seconds, List<Double> radii) {
        this.stop("dab-bands");
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Location base = target.getLocation();
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            int spawnedNow = 0;
            Iterator iterator = radii.iterator();
            while (iterator.hasNext()) {
                double ring = (Double)iterator.next();
                for (int i = 0; i < perBand; ++i) {
                    double ang = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                    Location at = base.clone().add(Math.cos(ang) * ring, 0.0, Math.sin(ang) * ring);
                    at = world.getHighestBlockAt(at).getLocation().add(0.5, 1.0, 0.5);
                    try {
                        Entity e = world.spawnEntity(at, type, false);
                        this.spawned.add(e.getUniqueId());
                        ++spawnedNow;
                        if (!(e instanceof Mob)) continue;
                        Mob mob = (Mob)e;
                        mob.setTarget((LivingEntity)target);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            target.sendMessage("\u00a7e[stress]\u00a77 DAB bands spawned: \u00a7b" + spawnedNow + "\u00a77 entities in \u00a7b" + radii.size() + "\u00a77 rings.");
        });
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            if (!target.isOnline()) {
                return;
            }
            for (World w : Bukkit.getWorlds()) {
                for (Entity e : w.getEntities()) {
                    Mob mob;
                    if (!this.spawned.contains(e.getUniqueId()) || !(e instanceof Mob) || (mob = (Mob)e).isDead() || mob.getTarget() != null && mob.getTarget().equals((Object)target)) continue;
                    mob.setTarget((LivingEntity)target);
                }
            }
        }, 40L, 40L);
        this.runningTasks.put("dab-bands", task);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.stop("dab-bands"), (long)seconds * 20L);
    }

    public void startVisibilityDense(Player center, EntityType type, int count, double radius, int seconds) {
        this.stop("vis-dense");
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Location base = center.getLocation();
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            int spawnedNow = 0;
            for (int i = 0; i < count; ++i) {
                double ang = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                double dist = ThreadLocalRandom.current().nextDouble(0.0, radius);
                Location at = base.clone().add(Math.cos(ang) * dist, 0.0, Math.sin(ang) * dist);
                at = world.getHighestBlockAt(at).getLocation().add(0.5, 1.0, 0.5);
                try {
                    Entity e = world.spawnEntity(at, type, false);
                    this.spawned.add(e.getUniqueId());
                    ++spawnedNow;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            center.sendMessage("\u00a7e[stress]\u00a77 Visibility dense spawn: \u00a7b" + spawnedNow + "\u00a77 within r=\u00a7b" + String.format(Locale.US, "%.1f", radius));
        });
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {}, 1L, 20L);
        this.runningTasks.put("vis-dense", task);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.stop("vis-dense"), (long)seconds * 20L);
    }

    public void startMovePath(final Player target, final double radius, int seconds, final int periodTicks) {
        this.stop("move");
        final Location origin = target.getLocation().clone();
        this.moveOriginal.put(target.getUniqueId(), origin);
        final World world = origin.getWorld();
        if (world == null) {
            return;
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, new Runnable(){
            int tick = 0;

            @Override
            public void run() {
                if (!target.isOnline()) {
                    StressTester.this.stop("move");
                    return;
                }
                this.tick += Math.max(1, periodTicks);
                double theta = (double)this.tick / 20.0 * 0.7853981633974483;
                double x = origin.getX() + Math.cos(theta) * radius;
                double z = origin.getZ() + Math.sin(theta) * radius;
                double y = origin.getY();
                Location to = new Location(world, x, y, z, target.getLocation().getYaw(), target.getLocation().getPitch());
                target.teleport(to);
            }
        }, 1L, (long)Math.max(1, periodTicks));
        this.runningTasks.put("move", task);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.stop("move"), (long)seconds * 20L);
    }
}

