/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.tracker;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.texboobcat.pufferLike.hologram.HologramService;

public class VisibilityCullingService {
    private final Plugin plugin;
    private final FileConfiguration cfg;
    private boolean enabled;
    private double radius;
    private boolean exemptPlayers;
    private Set<String> includeTypes;
    private Set<String> excludeTypes;
    private int maxPlayersPerTick;
    private int maxOpsPerTick;
    private long periodTicks;
    private boolean integrateHolograms;
    private final HologramService holograms;
    private final Map<UUID, Set<UUID>> hiddenByPlayer = new ConcurrentHashMap<UUID, Set<UUID>>();
    private final Deque<UUID> playerRoundRobin = new ArrayDeque<UUID>();
    private long totalHideOps = 0L;
    private long totalShowOps = 0L;

    public VisibilityCullingService(Plugin plugin, FileConfiguration cfg, HologramService holograms) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.holograms = holograms;
        this.reload();
    }

    public void reload() {
        this.enabled = this.cfg.getBoolean("tracker.visibility.enabled", false);
        this.radius = Math.max(8.0, this.cfg.getDouble("tracker.visibility.radius", 96.0));
        this.exemptPlayers = this.cfg.getBoolean("tracker.visibility.exempt-players", true);
        this.includeTypes = new HashSet<String>(this.cfg.getStringList("tracker.visibility.include-types"));
        this.excludeTypes = new HashSet<String>(this.cfg.getStringList("tracker.visibility.exclude-types"));
        this.maxPlayersPerTick = Math.max(1, this.cfg.getInt("tracker.visibility.max-players-per-tick", 4));
        this.maxOpsPerTick = Math.max(50, this.cfg.getInt("tracker.visibility.max-ops-per-tick", 400));
        this.periodTicks = Math.max(1L, this.cfg.getLong("tracker.visibility.period-ticks", 20L));
        this.integrateHolograms = this.cfg.getBoolean("tracker.visibility.integrate-holograms", true);
    }

    public void start() {
        Bukkit.getScheduler().runTaskTimer(this.plugin, this::tick, 40L, this.periodTicks);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerLifecycleListener(), this.plugin);
    }

    public void stop() {
    }

    private void ensurePlayerList() {
        if (this.playerRoundRobin.isEmpty()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.playerRoundRobin.add(p.getUniqueId());
            }
        }
    }

    private boolean typeAllowed(EntityType type) {
        String name = type.name();
        if (!this.includeTypes.isEmpty() && !this.includeTypes.contains(name)) {
            return false;
        }
        return this.excludeTypes.isEmpty() || !this.excludeTypes.contains(name);
    }

    private void tick() {
        if (!this.enabled) {
            return;
        }
        this.ensurePlayerList();
        int playersProcessed = 0;
        int ops = 0;
        block8: while (playersProcessed < this.maxPlayersPerTick && !this.playerRoundRobin.isEmpty() && ops < this.maxOpsPerTick) {
            UUID puid = this.playerRoundRobin.pollFirst();
            Player p = Bukkit.getPlayer((UUID)puid);
            if (p == null || !p.isOnline()) continue;
            this.playerRoundRobin.addLast(puid);
            ++playersProcessed;
            Set hidden = this.hiddenByPlayer.computeIfAbsent(puid, k -> ConcurrentHashMap.newKeySet());
            HashSet<UUID> visible = new HashSet<UUID>();
            for (Entity e : p.getWorld().getNearbyEntities(p.getLocation(), this.radius, this.radius, this.radius)) {
                if (this.exemptPlayers && e instanceof Player || !this.typeAllowed(e.getType())) continue;
                visible.add(e.getUniqueId());
                if (!hidden.contains(e.getUniqueId())) continue;
                try {
                    p.showEntity(this.plugin, e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.integrateHolograms && this.holograms != null) {
                    try {
                        this.holograms.showForPlayer(p, e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                hidden.remove(e.getUniqueId());
                ++this.totalShowOps;
                if (++ops < this.maxOpsPerTick) continue;
                break;
            }
            if (ops >= this.maxOpsPerTick) break;
            for (Entity e : p.getWorld().getNearbyEntities(p.getLocation(), this.radius * 2.0, this.radius * 2.0, this.radius * 2.0)) {
                UUID id;
                if (this.exemptPlayers && e instanceof Player || !this.typeAllowed(e.getType()) || visible.contains(id = e.getUniqueId()) || hidden.contains(id)) continue;
                try {
                    p.hideEntity(this.plugin, e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.integrateHolograms && this.holograms != null) {
                    try {
                        this.holograms.hideForPlayer(p, e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                hidden.add(id);
                ++this.totalHideOps;
                if (++ops < this.maxOpsPerTick) continue;
                continue block8;
            }
        }
    }

    public int getPlayersTrackedCount() {
        return this.hiddenByPlayer.size();
    }

    public long getTotalHiddenCount() {
        long sum = 0L;
        for (Set<UUID> s : this.hiddenByPlayer.values()) {
            sum += (long)s.size();
        }
        return sum;
    }

    public long getTotalHideOps() {
        return this.totalHideOps;
    }

    public long getTotalShowOps() {
        return this.totalShowOps;
    }

    private class PlayerLifecycleListener
    implements Listener {
        private PlayerLifecycleListener() {
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent e) {
            UUID id = e.getPlayer().getUniqueId();
            VisibilityCullingService.this.playerRoundRobin.addLast(id);
            VisibilityCullingService.this.hiddenByPlayer.computeIfAbsent(id, k -> ConcurrentHashMap.newKeySet());
        }

        @EventHandler
        public void onQuit(PlayerQuitEvent e) {
            UUID id = e.getPlayer().getUniqueId();
            VisibilityCullingService.this.hiddenByPlayer.remove(id);
            VisibilityCullingService.this.playerRoundRobin.removeIf(u -> u.equals(id));
        }
    }
}

