/*
 * Decompiled with CFR 0.152.
 */
package dev.yhdgms1.shadow_clones;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class Helpers {
    private Helpers() {
    }

    public static int getClonesSpawnCount(float health, float maxHealth) {
        if (health <= 1.0f) {
            return 0;
        }
        if (health <= maxHealth * 0.5f) {
            return 1;
        }
        if (health <= maxHealth * 0.75f) {
            return 2;
        }
        return 3;
    }

    private static double getAndleStep(int clonesSpawnCount) {
        if (clonesSpawnCount == 1) {
            return 0.0;
        }
        if (clonesSpawnCount == 2) {
            return 45.0;
        }
        return 60.0;
    }

    private static class_243 getSpawnPosition(double x, double y, double z, double yawRadians, double angleStep) {
        float radius = 2.0f;
        return new class_243(x - (double)radius * Math.sin(yawRadians - angleStep), y, z + (double)radius * Math.cos(yawRadians - angleStep));
    }

    public static List<class_243> getSpawnPositions(int clonesCount, class_3222 player) {
        ArrayList<class_243> spawnPositions = new ArrayList<class_243>();
        double playerX = player.method_23317();
        double playerY = player.method_23318();
        double playerZ = player.method_23321();
        double yawRadians = Math.toRadians(player.method_36454());
        double angleStep = Math.toRadians(Helpers.getAndleStep(clonesCount));
        if (clonesCount == 1) {
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, 0.0));
        } else if (clonesCount == 2) {
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, -angleStep));
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, angleStep));
        } else {
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, -angleStep));
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, 0.0));
            spawnPositions.add(Helpers.getSpawnPosition(playerX, playerY, playerZ, yawRadians, angleStep));
        }
        return spawnPositions;
    }
}

