/*
 * Decompiled with CFR 0.152.
 */
package dev.yhdgms1.shadow_clones;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import dev.yhdgms1.shadow_clones.CloneEntity;
import dev.yhdgms1.shadow_clones.CloneEntitySlim;
import dev.yhdgms1.shadow_clones.Helpers;
import dev.yhdgms1.shadow_clones.SummonShadowClonesC2SPayload;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowClones
implements ModInitializer {
    public static final String MOD_ID = "shadow_clones";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shadow_clones");
    public static final class_2960 CLONE_ID = class_2960.method_60655((String)"shadow_clones", (String)"clone");
    public static final class_5321<class_1299<?>> CLONE_KEY = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)CLONE_ID);
    public static final class_1299<CloneEntity> CLONE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)CLONE_ID, (Object)class_1299.class_1300.method_5903(CloneEntity::new, (class_1311)class_1311.field_17715).method_17687(0.6f, 1.8f).method_5905(CLONE_KEY));
    public static final class_2960 CLONE_SLIM_ID = class_2960.method_60655((String)"shadow_clones", (String)"clone_slim");
    public static final class_5321<class_1299<?>> CLONE_SLIM_KEY = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)CLONE_SLIM_ID);
    public static final class_1299<CloneEntitySlim> CLONE_SLIM = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)CLONE_SLIM_ID, (Object)class_1299.class_1300.method_5903(CloneEntitySlim::new, (class_1311)class_1311.field_17715).method_17687(0.6f, 1.8f).method_5905(CLONE_SLIM_KEY));
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

    public void onInitialize() {
        FabricDefaultAttributeRegistry.register(CLONE, (class_5132.class_5133)CloneEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(CLONE_SLIM, (class_5132.class_5133)CloneEntitySlim.createAttributes());
        PayloadTypeRegistry.playC2S().register(SummonShadowClonesC2SPayload.ID, SummonShadowClonesC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SummonShadowClonesC2SPayload.ID, (payload, context) -> {
            int cloneCount;
            class_3222 player = context.player();
            class_3218 world = player.method_51469();
            GameProfile gameProfile = player.method_7334();
            String profileName = gameProfile.getName();
            String ownerId = gameProfile.getId().toString();
            Optional<Object> skinURL = Optional.empty();
            PropertyMap propertyMap = gameProfile.getProperties();
            if (!propertyMap.isEmpty()) {
                Property property = (Property)propertyMap.get((Object)"textures").iterator().next();
                String json = new String(Base64.getDecoder().decode(property.value()), StandardCharsets.UTF_8);
                MinecraftTexturesPayload result = (MinecraftTexturesPayload)gson.fromJson(json, MinecraftTexturesPayload.class);
                MinecraftProfileTexture texture = (MinecraftProfileTexture)result.textures().get(MinecraftProfileTexture.Type.SKIN);
                skinURL = Optional.of(texture.getUrl());
            }
            String modelType = payload.modelType();
            class_1934 gameMode = player.method_68876();
            float health = player.method_6032();
            int n = cloneCount = gameMode == class_1934.field_9220 ? 3 : Helpers.getClonesSpawnCount(health, player.method_6063());
            if (cloneCount == 0) {
                return;
            }
            if (gameMode == class_1934.field_9215) {
                player.method_6033(health - (float)cloneCount * 1.5f);
            }
            List<class_243> spawnPositions = Helpers.getSpawnPositions(cloneCount, player);
            float playerYaw = player.method_36454();
            float playerBodyYaw = player.method_43078();
            for (class_243 spawnPos : spawnPositions) {
                CloneEntity entity = modelType.equals("slim") ? new CloneEntitySlim((class_1299<? extends CloneEntity>)CLONE_SLIM, (class_1937)world) : new CloneEntity(CLONE, (class_1937)world);
                for (class_1304 slot : class_1304.values()) {
                    class_1304.class_1305 type = slot.method_5925();
                    if (type != class_1304.class_1305.field_6178 && type != class_1304.class_1305.field_6177) continue;
                    entity.method_5673(slot, player.method_6118(slot).method_7972());
                    entity.method_5946(slot, 0.0f);
                }
                skinURL.ifPresent(entity::setSkinURL);
                entity.setOwnerId(ownerId);
                entity.setProfileName(profileName);
                entity.method_23327(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350);
                entity.method_36456(playerYaw);
                entity.method_5636(playerBodyYaw);
                world.method_8649((class_1297)entity);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            String name = handler.field_14140.method_7334().getName();
            for (class_3218 world : server.method_3738()) {
                for (CloneEntity clone : world.method_18198(class_5575.method_31795(CloneEntity.class), entity -> entity.getProfileName().equals(name))) {
                    clone.method_5768(world);
                }
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            String name = newPlayer.method_7334().getName();
            MinecraftServer server = newPlayer.method_5682();
            if (server != null) {
                for (class_3218 world : server.method_3738()) {
                    for (CloneEntity clone : world.method_18198(class_5575.method_31795(CloneEntity.class), entity -> entity.getProfileName().equals(name))) {
                        clone.method_5768(world);
                    }
                }
            }
        });
        AttackEntityCallback.EVENT.register((playerEntity, world, hand, entity, entityHitResult) -> {
            if (!world.field_9236 && entity instanceof CloneEntity) {
                entity.method_5768((class_3218)world);
            }
            if (!world.field_9236 && entity instanceof class_1309) {
                class_3218 serverWorld = (class_3218)world;
                String ownerName = playerEntity.method_7334().getName();
                for (CloneEntity clone : serverWorld.method_18198(class_5575.method_31795(CloneEntity.class), c -> c.getProfileName().equals(ownerName))) {
                    clone.method_29513(entity.method_5667());
                    clone.method_29514(300);
                    clone.method_5980((class_1309)entity);
                }
            }
            return class_1269.field_5811;
        });
    }
}

