/*
 * Decompiled with CFR 0.152.
 */
package dev.yhdgms1.shadow_clones;

import com.mojang.authlib.GameProfile;
import dev.yhdgms1.shadow_clones.CloneEntity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;

@Environment(value=EnvType.CLIENT)
public class TextureManager {
    private static final HashMap<String, LoadingTexture> CACHE = new HashMap();
    private static final long TTL = 600000L;

    private TextureManager() {
    }

    private static class_1011 fetchImage(String url) {
        class_1011 class_10112;
        block8: {
            InputStream in = URI.create(url).toURL().openStream();
            try {
                class_10112 = class_1011.method_4309((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            in.close();
        }
        return class_10112;
    }

    public static LoadingTexture loadTexture(String url) {
        LoadingTexture loadingTexture;
        if (CACHE.containsKey(url) && !(loadingTexture = CACHE.get(url)).isExpired()) {
            return loadingTexture;
        }
        loadingTexture = new LoadingTexture();
        CACHE.put(url, loadingTexture);
        try (class_1011 image = TextureManager.fetchImage(url);){
            if (image == null) {
                loadingTexture.state = State.COMPLETE;
            } else {
                UUID uuid = UUID.randomUUID();
                class_1043 texture = new class_1043(uuid::toString, image);
                class_2960 identifier = class_2960.method_60655((String)"shadow_clones", (String)uuid.toString());
                class_310.method_1551().method_1531().method_4616(identifier, (class_1044)texture);
                loadingTexture.state = State.COMPLETE;
                loadingTexture.texture = Optional.of(identifier);
            }
        }
        return loadingTexture;
    }

    public static Optional<class_8685> getOfflineTextures(CloneEntity entity) {
        String ownerId = entity.getOwnerId();
        if (!ownerId.isEmpty()) {
            GameProfile gameProfile = new GameProfile(UUID.fromString(ownerId), entity.getProfileName());
            class_8685 textures = class_310.method_1551().method_1582().method_52862(gameProfile);
            return Optional.of(textures);
        }
        return Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingTexture {
        public State state = State.PENDING;
        public Optional<class_2960> texture = Optional.empty();
        public long expiry = 600000L + System.currentTimeMillis();

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiry;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum State {
        PENDING,
        COMPLETE;

    }
}

