/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClientBoundParticleAroundBlockPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundParticleAroundBlockPacket> TYPE = Message.makeType(Moonlight.res("s2c_particle"), ClientBoundParticleAroundBlockPacket::new);
    public final Kind type;
    public final BlockPos pos;

    public ClientBoundParticleAroundBlockPacket(RegistryFriendlyByteBuf buffer) {
        this.type = (Kind)buffer.readEnum(Kind.class);
        this.pos = buffer.readBlockPos();
    }

    public ClientBoundParticleAroundBlockPacket(BlockPos pos, Kind type) {
        this.pos = pos;
        this.type = type;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
        buffer.writeBlockPos(this.pos);
    }

    @Override
    public void handle(Message.Context context) {
        ClientBoundParticleAroundBlockPacket.handleSpawnBlockParticlePacket(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnBlockParticlePacket(ClientBoundParticleAroundBlockPacket message) {
        ClientLevel l = Minecraft.getInstance().level;
        switch (message.type.ordinal()) {
            case 0: {
                ParticleUtil.spawnParticleOnBlockShape((Level)l, message.pos, (ParticleOptions)ParticleTypes.WAX_ON, UniformInt.of((int)3, (int)5), 0.01f);
                break;
            }
            case 1: {
                ParticleUtil.spawnParticleOnBlockShape((Level)l, message.pos, (ParticleOptions)ParticleTypes.GLOW, UniformInt.of((int)3, (int)5), 0.0f);
            }
        }
    }

    public static enum Kind {
        WAX_ON,
        GLOW_ON;

    }
}

