/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.misc.SlotProvider;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public interface InvPlacer {
    public static final SimplePlacer EXISTING = InvPlacer.of(SlotProvider.ALL, stack -> !stack.method_7960());
    public static final SimplePlacer EMPTY = InvPlacer.of(SlotProvider.ALL, class_1799::method_7960);
    public static final SimplePlacer ANY = InvPlacer.of(SlotProvider.ALL);
    public static final InvPlacer DEFAULT = EXISTING.or(ANY);
    public static final InvPlacer DROP = (stack, inventory, player) -> {
        player.method_7328(stack, false);
        return true;
    };

    public boolean place(class_1799 var1, class_1661 var2, class_1657 var3);

    default public InvPlacer or(InvPlacer other) {
        return (stack, inventory, player) -> this.place(stack, inventory, player) || other.place(stack, inventory, player);
    }

    public static ExclusivePlacer exclusiveSequence() {
        return new ExclusivePlacer();
    }

    public static SimplePlacer of(SlotProvider slots) {
        return InvPlacer.of(slots, (Predicate<class_1799>)Predicates.alwaysTrue());
    }

    public static SimplePlacer of(SlotProvider slots, Predicate<class_1799> predicate) {
        return new SimplePlacer(slots, predicate);
    }

    public static InvPlacer handOrExistingOrAnyAvoidEmptyHand(class_1268 hand) {
        return InvPlacer.exclusiveSequence().stage(InvPlacer.handNotEmpty(hand)).stage(EXISTING).stage(ANY).or(ANY);
    }

    public static InvPlacer handOrExistingOrAny(class_1268 hand) {
        return InvPlacer.hand(hand).or(EXISTING).or(ANY);
    }

    public static InvPlacer existingOrAny() {
        return DEFAULT;
    }

    public static SimplePlacer handNotEmpty(class_1268 hand) {
        return InvPlacer.hand(hand, stack -> !stack.method_7960());
    }

    public static SimplePlacer hand(class_1268 hand) {
        return InvPlacer.hand(hand, (Predicate<class_1799>)Predicates.alwaysTrue());
    }

    public static SimplePlacer hand(class_1268 hand, Predicate<class_1799> predicate) {
        return InvPlacer.of(SlotProvider.hand(hand), predicate);
    }

    public static SimplePlacer slot(int slot) {
        return InvPlacer.of(SlotProvider.single(slot));
    }

    public static class ExclusivePlacer
    implements InvPlacer {
        private final List<Stage> stages = new ArrayList<Stage>();
        private final Set<SlotProvider.Slot> visitedSlots = new HashSet<SlotProvider.Slot>();

        public ExclusivePlacer stage(SlotProvider provider, Predicate<class_1799> predicate) {
            this.stage(InvPlacer.of(provider, predicate));
            return this;
        }

        public ExclusivePlacer stage(SlotProvider provider) {
            return this.stage(provider, (Predicate<class_1799>)Predicates.alwaysTrue());
        }

        public ExclusivePlacer stage(Stage stage) {
            this.stages.add(stage);
            return this;
        }

        @Override
        public boolean place(class_1799 stack, class_1661 inventory, class_1657 player) {
            for (Stage stage : this.stages) {
                Iterator<SlotProvider.Slot> slots = stage.slotProvider().getSlots(inventory);
                while (slots.hasNext()) {
                    Predicate<class_1799> predicate;
                    SlotProvider.Slot slot = slots.next();
                    if (this.visitedSlots.contains(slot) || !(predicate = stage.predicate()).test(slot.getStack())) continue;
                    this.visitedSlots.add(slot);
                    if (slot.add(stack, inventory, player)) {
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        static interface Stage {
            public SlotProvider slotProvider();

            public Predicate<class_1799> predicate();
        }
    }

    public record SimplePlacer(SlotProvider slotProvider, Predicate<class_1799> predicate) implements InvPlacer,
    ExclusivePlacer.Stage
    {
        @Override
        public boolean place(class_1799 stack, class_1661 inventory, class_1657 player) {
            Iterator<SlotProvider.Slot> iterator = this.slotProvider.getSlots(inventory);
            while (iterator.hasNext()) {
                SlotProvider.Slot slot = iterator.next();
                if (!this.predicate.test(slot.getStack()) || !slot.add(stack, inventory, player)) continue;
                return true;
            }
            return false;
        }
    }
}

