/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public interface SlotProvider {
    public static final SlotProvider ALL = inv -> IntStream.range(0, inv.field_7547.size()).mapToObj(i -> Slot.invSlot(inv, i)).iterator();
    public static final SlotProvider OFF_HAND = inv -> IntStream.range(0, inv.field_7544.size()).mapToObj(i -> Slot.offHandSlot(inv, i)).iterator();
    public static final SlotProvider MAIN_HAND = inv -> List.of(Slot.invSlot(inv, inv.field_7545)).iterator();

    public Iterator<Slot> getSlots(class_1661 var1);

    public static SlotProvider hand(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return MAIN_HAND;
        }
        return OFF_HAND;
    }

    public static SlotProvider single(int slot) {
        return inv -> List.of(Slot.invSlot(inv, slot)).iterator();
    }

    public static interface Slot {
        public class_1799 getStack();

        public boolean add(class_1799 var1, class_1661 var2, class_1657 var3);

        public static Slot invSlot(final class_1661 inv, final int slot) {
            return new Slot(){

                @Override
                public class_1799 getStack() {
                    return inv.method_5438(slot);
                }

                @Override
                public boolean add(class_1799 toAdd, class_1661 inv2, class_1657 player) {
                    class_1799 current = this.getStack();
                    if (!current.method_7960() && !inv2.method_7393(current, toAdd)) {
                        return false;
                    }
                    if (toAdd.method_7960()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = toAdd.method_7947();
                            toAdd.method_7939(inv2.method_7385(slot, toAdd));
                        } while (!toAdd.method_7960() && toAdd.method_7947() < originalCount);
                        return toAdd.method_7947() < originalCount;
                    }
                    catch (Throwable var6) {
                        class_128 crashReport = class_128.method_560((Throwable)var6, (String)"Adding item to inventory");
                        class_129 crashReportCategory = crashReport.method_562("Item being added");
                        crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)toAdd.method_7909()));
                        crashReportCategory.method_578("Item data", (Object)toAdd.method_7919());
                        crashReportCategory.method_577("Item name", () -> toAdd.method_7964().getString());
                        throw new class_148(crashReport);
                    }
                }
            };
        }

        public static Slot offHandSlot(final class_1661 inv, final int offHandSlot) {
            return new Slot(){

                @Override
                public class_1799 getStack() {
                    return (class_1799)inv.field_7544.get(offHandSlot);
                }

                @Override
                public boolean add(class_1799 stack, class_1661 inv2, class_1657 player) {
                    if (stack.method_7960()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = stack.method_7947();
                            this.addResourceOffHand(stack, inv2);
                        } while (!stack.method_7960() && stack.method_7947() < originalCount);
                        if (stack.method_7947() == originalCount && player.method_31549().field_7477) {
                            stack.method_7939(0);
                            return true;
                        }
                        return stack.method_7947() < originalCount;
                    }
                    catch (Throwable var6) {
                        class_128 crashReport = class_128.method_560((Throwable)var6, (String)"Adding item to inventory");
                        class_129 crashReportCategory = crashReport.method_562("Item being added");
                        crashReportCategory.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
                        crashReportCategory.method_578("Item data", (Object)stack.method_7919());
                        crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                        throw new class_148(crashReport);
                    }
                }

                private void addResourceOffHand(class_1799 toAdd, class_1661 inv2) {
                    class_2371 offHand = inv2.field_7544;
                    for (int offSlot = 0; offSlot < offHand.size(); ++offSlot) {
                        int stackCount = toAdd.method_7947();
                        class_1799 itemStack = (class_1799)offHand.get(offSlot);
                        if (itemStack.method_7960()) {
                            itemStack = toAdd.method_46651(0);
                            offHand.set(offSlot, (Object)itemStack);
                            return;
                        }
                        int possibleSpace = inv2.method_58350(itemStack) - itemStack.method_7947();
                        int addedCount = Math.min(stackCount, possibleSpace);
                        if (addedCount == 0) continue;
                        itemStack.method_7933(addedCount);
                        itemStack.method_7912(5);
                        toAdd.method_7939(stackCount -= addedCount);
                    }
                }
            };
        }
    }
}

