/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.SyncConfigsMessage;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class ModConfigHolder {
    private static final Map<class_2960, ModConfigHolder> CONFIG_STORAGE = new ConcurrentHashMap<class_2960, ModConfigHolder>();
    private final class_2960 configId;
    private final String fileName;
    private final class_2561 readableName;
    private final Path filePath;
    private final ConfigType type;
    @Nullable
    private final Runnable changeCallback;

    public static void addTrackedSpec(ModConfigHolder spec) {
        ModConfigHolder old = CONFIG_STORAGE.put(spec.getId(), spec);
        if (old != null) {
            throw new IllegalStateException("Duplicate config type for with id " + String.valueOf(spec.getId()));
        }
    }

    public static Collection<ModConfigHolder> getTrackedSpecs() {
        return CONFIG_STORAGE.values();
    }

    @Nullable
    public static ModConfigHolder getConfigSpec(class_2960 configId) {
        return CONFIG_STORAGE.get(configId);
    }

    protected ModConfigHolder(class_2960 id, String fileExtension, Path configDirectory, ConfigType type, @Nullable Runnable changeCallback) {
        this.configId = id;
        this.fileName = id.method_12836() + "-" + id.method_12832() + "." + fileExtension;
        this.filePath = configDirectory.resolve(this.fileName);
        this.type = type;
        this.changeCallback = changeCallback;
        this.readableName = class_2561.method_43470((String)LangBuilder.getReadableName(id.method_36181() + "_configs"));
        ModConfigHolder.addTrackedSpec(this);
    }

    public class_2561 getReadableName() {
        return this.readableName;
    }

    protected void onRefresh() {
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public abstract void forceLoad();

    public ConfigType getConfigType() {
        return this.type;
    }

    public String getModId() {
        return this.configId.method_12836();
    }

    public class_2960 getId() {
        return this.configId;
    }

    public boolean isSynced() {
        return this.type.isSynced();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFullPath() {
        return this.filePath;
    }

    public abstract void loadFromBytes(InputStream var1, boolean var2);

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent) {
        return this.makeScreen(parent, null);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public abstract class_437 makeScreen(class_437 var1, @Nullable class_2960 var2);

    public abstract boolean hasConfigScreen();

    public void syncConfigsToPlayer(class_3222 player) {
        if (this.isSynced()) {
            try {
                byte[] configData = this.getConfigFileData();
                NetworkHelper.sendToClientPlayer(player, new SyncConfigsMessage(configData, this.getId()));
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Failed to sync common configs {}", (Object)this.getFileName(), (Object)e);
            }
        } else {
            throw new UnsupportedOperationException("Tried to sync a config of type " + String.valueOf((Object)this.getConfigType()));
        }
    }

    public void sendChangedConfigToServer() {
        if (this.isSynced()) {
            try {
                byte[] configData = this.getConfigFileData();
                NetworkHelper.sendToServer(new SyncConfigsMessage(configData, this.getId()));
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Failed to sync common configs {}", (Object)this.getFileName(), (Object)e);
            }
        }
    }

    protected byte[] getConfigFileData() throws IOException {
        return Files.readAllBytes(this.getFullPath());
    }

    public void sendSyncedConfigsToAllPlayers() {
        if (this.isSynced()) {
            MinecraftServer currentServer = PlatHelper.getCurrentServer();
            if (currentServer != null) {
                class_3324 playerList = currentServer.method_3760();
                for (class_3222 player : playerList.method_14571()) {
                    this.syncConfigsToPlayer(player);
                }
            }
        } else {
            throw new UnsupportedOperationException("Tried to sync a config of type " + String.valueOf((Object)this.getConfigType()));
        }
    }

    public static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfigHolder config, Exception cause) {
            super("Failed to load config file " + config.getFileName() + " of type " + String.valueOf((Object)config.getConfigType()) + " for mod " + config.getModId() + ". Try deleting it", cause);
        }
    }
}

