/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.IntConfigValue;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class ColorConfigValue
extends IntConfigValue {
    public ColorConfigValue(String name, int defaultValue) {
        super(name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                String s = element.get(this.name).getAsString();
                Optional result = ColorUtils.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(s)).result();
                if (result.isPresent()) {
                    this.value = ((Pair)result.get()).getFirst();
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            Moonlight.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        object.addProperty(this.name, ((JsonElement)ColorUtils.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Integer)this.value)).result().get()).getAsString());
    }

    @Override
    public String getExtraInfo() {
        return "Accepted format: Hexadecimal color code (e.g., #RRGGBB or #AARRGGBB)";
    }
}

