/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import net.mehvahdjukaar.moonlight.api.resources.pack.CacheZipPackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.GlobalCachedStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.InMemoryPackResources;
import net.minecraft.class_3264;
import net.minecraft.class_9224;

public interface PackGenerationStrategy {
    public static final PackGenerationStrategy REGEN_ON_EVERY_RELOAD = new PackGenerationStrategy(){

        @Override
        public boolean needsRegeneration(class_3264 packType) {
            return true;
        }

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new InMemoryPackResources(info, type);
        }

        public String toString() {
            return "REGEN_ON_EVERY_RELOAD";
        }
    };
    public static final PackGenerationStrategy NO_OP = new PackGenerationStrategy(){

        @Override
        public boolean needsRegeneration(class_3264 packType) {
            return false;
        }

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new InMemoryPackResources(info, type);
        }

        public String toString() {
            return "NO_OP";
        }
    };
    public static final PackGenerationStrategy CACHED = new GlobalCachedStrategy();
    public static final PackGenerationStrategy CACHED_ZIPPED = new GlobalCachedStrategy(){

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new CacheZipPackResources(info, type, this.getPath(type).resolve(info.comp_2329().replace(":", "-")));
        }

        @Override
        public String toString() {
            return "CACHED_ZIPPED";
        }
    };

    public boolean needsRegeneration(class_3264 var1);

    public IEditablePackResources createPackResources(class_9224 var1, class_3264 var2);

    public static PackGenerationStrategy runOnce() {
        return new PackGenerationStrategy(){
            private boolean done = false;

            @Override
            public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
                return new InMemoryPackResources(info, type);
            }

            @Override
            public boolean needsRegeneration(class_3264 packType) {
                if (!this.done) {
                    this.done = true;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "RUN_ONCE";
            }
        };
    }
}

