/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.core.commands.BackCommand;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7157;

public class RandomTeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.teleport.invalidPosition"));

    public static ArgumentBuilder<class_2168, ?> register(class_7157 context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpr").requires(p -> p.method_9259(2))).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<class_2168>)c, List.of(((class_2168)c.getSource()).method_9229()), Optional.empty()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<class_2168>)c, List.of(((class_2168)c.getSource()).method_9229()), Optional.of(DoubleArgumentType.getDouble((CommandContext)c, (String)"radius"))))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<class_2168>)c, class_2186.method_9317((CommandContext)c, (String)"targets"), Optional.of(DoubleArgumentType.getDouble((CommandContext)c, (String)"radius"))))))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<class_2168>)c, class_2186.method_9317((CommandContext)c, (String)"targets"), Optional.empty())));
    }

    private static int teleportRandom(CommandContext<class_2168> context, Collection<? extends class_1297> targets, Optional<Double> optRadius) throws CommandSyntaxException {
        double zMax;
        double zMin;
        double xMax;
        double xMin;
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        class_5819 random = level.method_8409();
        class_2784 border = level.method_8621();
        if (optRadius.isPresent()) {
            double centerZ;
            double radius = optRadius.get();
            try {
                class_1297 src = source.method_9229();
                var17_11 = src.method_23317();
                centerZ = src.method_23321();
            }
            catch (CommandSyntaxException e) {
                var17_11 = border.method_11964();
                centerZ = border.method_11980();
            }
            xMin = var17_11 - radius;
            xMax = var17_11 + radius;
            zMin = centerZ - radius;
            zMax = centerZ + radius;
        } else {
            double centerX = border.method_11964();
            var17_11 = border.method_11980();
            double half = border.method_11965() / 2.0;
            xMin = centerX - half;
            xMax = centerX + half;
            zMin = var17_11 - half;
            zMax = var17_11 + half;
        }
        EnumSet<class_2709> set = EnumSet.noneOf(class_2709.class);
        set.add(class_2709.field_12397);
        set.add(class_2709.field_12401);
        for (class_1297 class_12972 : targets) {
            double sampledX = xMin + random.method_43058() * (xMax - xMin);
            double sampledZ = zMin + random.method_43058() * (zMax - zMin);
            class_2338 clamped = border.method_39538(sampledX, 0.0, sampledZ);
            double x = clamped.method_10263();
            double z = clamped.method_10260();
            int xi = class_3532.method_15357((double)x);
            int zi = class_3532.method_15357((double)z);
            int finalY = 70;
            class_2338 blockPos = class_2338.method_49637((double)x, (double)finalY, (double)z);
            if (!class_1937.method_25953((class_2338)blockPos)) {
                throw INVALID_POSITION.create();
            }
            RandomTeleportCommand.performTeleport(source, class_12972, level, x, finalY, z, set);
        }
        class_243 example = targets.iterator().next().method_19538();
        if (targets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.teleport.success.location.single", (Object[])new Object[]{((class_1297)targets.iterator().next()).method_5476(), RandomTeleportCommand.formatDouble(example.field_1352), RandomTeleportCommand.formatDouble(example.field_1351), RandomTeleportCommand.formatDouble(example.field_1350)}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), RandomTeleportCommand.formatDouble(example.field_1352), RandomTeleportCommand.formatDouble(example.field_1351), RandomTeleportCommand.formatDouble(example.field_1350)}), true);
        }
        return targets.size();
    }

    private static void performTeleport(class_2168 source, class_1297 entity, class_3218 level, double x, double y, double z, Set<class_2709> relativeList) throws CommandSyntaxException {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            throw INVALID_POSITION.create();
        }
        float f = class_3532.method_15393((float)entity.method_36454());
        float g = class_3532.method_15393((float)entity.method_36455());
        class_2338 oldPos = entity.method_24515();
        class_5321 oldDim = entity.method_37908().method_27983();
        if (entity.method_48105(level, x, y, z, relativeList, f, g)) {
            class_1309 livingEntity;
            BackCommand.onTeleported(entity, oldPos, (class_5321<class_1937>)oldDim);
            if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_6128()) {
                entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
                entity.method_24830(true);
            }
            if (entity instanceof class_1314) {
                class_1314 pathfinderMob = (class_1314)entity;
                pathfinderMob.method_5942().method_6340();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

