/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.core.misc.fabric.FilteredResManagerImpl;
import net.mehvahdjukaar.moonlight.core.pack.MergedDynamicClientResourcesProvider;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_6861;

public class FilteredResManager
extends class_6861 {
    public FilteredResManager(class_3264 packType, List<class_3262> list) {
        super(packType, list);
    }

    public static FilteredResManager including(class_3300 original, class_3264 packType, String ... packs) {
        return FilteredResManager.including(original, packType, (class_3262 p) -> Set.of(packs).contains(p.method_14409()));
    }

    public static FilteredResManager including(class_3300 original, class_3264 packType, Predicate<class_3262> predicate) {
        List<class_3262> list = original.method_29213().toList().stream().filter(predicate).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager excluding(class_3300 original, class_3264 packType, String ... packs) {
        return FilteredResManager.excluding(original, packType, (class_3262 p) -> Set.of(packs).contains(p));
    }

    public static FilteredResManager excluding(class_3300 original, class_3264 packType, Predicate<class_3262> predicate) {
        List<class_3262> list = original.method_29213().toList().stream().filter(p -> !predicate.test((class_3262)p)).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager including(class_3283 original, class_3264 packType, String ... packs) {
        Set<String> whitelist = Set.of(packs);
        List<class_3262> list = original.method_14441().stream().filter(p -> whitelist.contains(p.method_14463())).map(class_3288::method_14458).toList();
        return new FilteredResManager(packType, list);
    }

    public static FilteredResManager excluding(class_3283 original, class_3264 packType, String ... packs) {
        Set<String> blacklist = Set.of(packs);
        List<class_3262> list = original.method_14441().stream().filter(p -> !blacklist.contains(p.method_14463())).map(class_3288::method_14458).toList();
        return new FilteredResManager(packType, list);
    }

    public static class_3300 vanilla(class_3300 manager, class_3264 type) {
        return FilteredResManager.including(manager, type, (class_3262 p) -> {
            String id = p.method_14409();
            if (id.equals("vanilla")) {
                return true;
            }
            if (FilteredResManager.isDynamicPackResource(p)) {
                return false;
            }
            if (FilteredResManager.isModResourcePack(p)) {
                return true;
            }
            return FilteredResManager.isModResourcePack(p);
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModResourcePack(class_3262 pack) {
        return FilteredResManagerImpl.isModResourcePack(pack);
    }

    public static boolean isDynamicPackResource(class_3262 p) {
        return p instanceof IEditablePackResources || p instanceof MergedDynamicClientResourcesProvider;
    }
}

