package net.mehvahdjukaar.moonlight.api.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundOpenScreenPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

/**
 * Implement in your blocks(deprecated) or tiles or entities. Just for utility method
 */
public interface IScreenProvider {

    @Environment(EnvType.CLIENT)
    default void openScreen(class_1937 level, class_1657 player, class_2350 direction) {
    }

    default void sendOpenGuiPacket(class_3222 player, @Nullable class_2350 hitFace) {
        TileOrEntityTarget target;
        if (this instanceof class_2586 be) {
            target = TileOrEntityTarget.of(be);
        } else if (this instanceof class_1657 entity) {
            target = TileOrEntityTarget.of(entity);
        } else {
            throw new IllegalStateException("IScreenProvider must be a BlockEntity or Entity");
        }
        NetworkHelper.sendToClientPlayer(player, new ClientBoundOpenScreenPacket(target, hitFace));
    }

}
