package net.mehvahdjukaar.moonlight.api.client.model;

import dev.architectury.injectables.annotations.ExpectPlatform;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.function.Consumer;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4590;
import net.minecraft.class_777;

/**
 * Cross loader utility to create baked quad
 * On forge just wraps its own baked quad builder. Can also be fed to render calls as it implements vertex consumer
 */
public interface BakedQuadBuilder extends class_4588, AutoCloseable {

    static BakedQuadBuilder create(class_1058 sprite, Consumer<class_777> quadConsumer) {
        return create(sprite, (Matrix4f) null, quadConsumer);
    }

    static BakedQuadBuilder create(class_1058 sprite, @Nullable class_4590 transformation, Consumer<class_777> quadConsumer) {
        return create(sprite, transformation == null ? null : new Matrix4f().translate(0.5f, 0.5f, 0.5f)
                        .mul(transformation.method_22936())
                        .translate(-0.5f, -0.5f, -0.5f),
                quadConsumer);
    }

    //
    @ExpectPlatform
    static BakedQuadBuilder create(class_1058 sprite, @Nullable Matrix4f transformation, Consumer<class_777> quadConsumer) {
        throw new AssertionError();
    }

    BakedQuadBuilder setAutoDirection();

    BakedQuadBuilder setDirection(class_2350 direction);

    BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion);

    BakedQuadBuilder setShade(boolean shade);

    BakedQuadBuilder lightEmission(int light);

    BakedQuadBuilder setTint(int tintIndex);

    @Override
    default BakedQuadBuilder method_22918(Matrix4f matrix, float x, float y, float z) {
        class_4588.super.method_22918(matrix, x, y, z);
        return this;
    }

    @Override
    default class_4588 method_60831(class_4587.class_4665 pose, float f, float g, float h) {
        class_4588.super.method_60831(pose, f, g, h);
        return this;
    }
}
