package net.mehvahdjukaar.moonlight.api.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.class_1087;
import net.minecraft.class_3665;
import net.minecraft.client.resources.model.*;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * Simple implementation of a dynamic model that accepts another model as a parameter
 */
public class NestedModelLoader implements CustomModelLoader {

    private final BiFunction<class_1087, class_3665, CustomBakedModel> factory;
    private final String path;

    public NestedModelLoader(String modelPath, BiFunction<class_1087, class_3665, CustomBakedModel> bakedModelFactory) {
        this.factory = bakedModelFactory;
        this.path = modelPath;
    }

    @Override
    public CustomGeometry deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        var j = json.get(path);
        return (modelBaker, spriteGetter, transform) -> {

            var baked = CustomModelLoader.parseModel(j, modelBaker, spriteGetter, transform);
            return factory.apply(baked, transform);
        };
    }

}