package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4f;

import java.util.function.BiConsumer;


public class RenderUtil {

    //TODO: fix shading so it can be rotated and have consistent shading and is also rendered like a block
    @ExpectPlatform
    public static void renderBlock(class_1087 model, long seed, class_4587 poseStack, class_4597 buffer, class_2680 state,
                                   class_1937 level, class_2338 pos, class_776 dispatcher) {
        throw new AssertionError();
    }

    public static void renderBlock(long seed, class_4587 poseStack, class_4597 buffer, class_2680 state,
                                   class_1937 level, class_2338 pos, class_776 dispatcher) {
        class_1087 model = dispatcher.method_3349(state);
        renderBlock(model, seed, poseStack, buffer, state, level, pos, dispatcher);
    }

    //should be a weaker version of what's above as it doesnt take in level so stuff like offset isnt there
    //from resource location
    public static void renderModel(class_1091 modelLocation, class_4587 matrixStack, class_4597 buffer,
                                   class_776 blockRenderer, int light, int overlay, boolean cutout) {

        blockRenderer.method_3350().method_3367(matrixStack.method_23760(),
                buffer.getBuffer(cutout ? class_4722.method_24074() : class_4722.method_24073()),
                null,
                ClientHelper.getModel(blockRenderer.method_3351().method_3333(), modelLocation),
                1.0F, 1.0F, 1.0F,
                light, overlay);
    }

    public static void renderGuiItemRelative(class_4587 poseStack, class_1799 stack, int x, int y, class_918 renderer,
                                             BiConsumer<class_4587, class_1087> movement) {
        renderGuiItemRelative(poseStack, stack, x, y, renderer, movement, class_765.field_32767, class_4608.field_21444);
    }


    //im not even using this on fabric...
    public static void renderGuiItemRelative(class_4587 poseStack, class_1799 stack, int x, int y, class_918 renderer,
                                             BiConsumer<class_4587, class_1087> movement, int combinedLight, int pCombinedOverlay) {

        class_1087 model = renderer.method_4019(stack, null, null, 0);
        int l = 0;

        poseStack.method_22903();

        poseStack.method_46416((x + 8), (y + 8), (150 + (model.method_4712() ? l : 0)));
        poseStack.method_34425((new Matrix4f()).scaling(1.0F, -1.0F, 1.0F));
        poseStack.method_22905(16.0F, 16.0F, 16.0F);

        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean flag = !model.method_24304();
        if (flag) {
            class_308.method_24210();
        } else {
            class_308.method_24211();
        }

        //-----render---
        class_811 pTransformType = class_811.field_4317;

        // applies rotation first then custom rot and gives display context of none
        model = handleCameraTransforms(model, poseStack, pTransformType);

        //custom rotation

        movement.accept(poseStack, model);

        renderer.method_23179(stack, class_811.field_4315, false, poseStack, bufferSource,
                combinedLight, pCombinedOverlay, model);

        //----end-render---

        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        poseStack.method_22909();
    }

    @ExpectPlatform
    private static class_1087 handleCameraTransforms(class_1087 model, class_4587 matrixStack, class_811 pTransformType) {
        throw new ArrayStoreException();
    }

    @Deprecated(forRemoval = true)
    public static class_332 getGuiDummy(class_4587 poseStack) {
        var mc = class_310.method_1551();
        var p = new class_332(mc, mc.method_22940().method_23000());
        p.method_51448().method_34426();
        p.method_51448().method_34425(poseStack.method_23760().method_23761());
        return p;
    }

    /**
     * Renders the given sprite or sprite section. Meant for GUI
     *
     * @param x      x position
     * @param y      y position
     * @param w      width
     * @param h      height
     * @param u      sprite local u
     * @param v      sprite local v
     * @param uW     sprite section width
     * @param vH     sprite section height
     * @param sprite can be grabbed from a material
     */
    public static void blitSpriteSection(class_332 graphics, int x, int y, int w, int h,
                                         float u, float v, int uW, int vH, class_1058 sprite) {
        var c = sprite.method_45851();
        int width = (int) (c.method_45807() / (sprite.method_4577() - sprite.method_4594()));
        int height = (int) (c.method_45815() / (sprite.method_4575() - sprite.method_4593()));
        graphics.method_25293(sprite.method_45852(), x, y, w, h, sprite.method_4580(u) * width, height * sprite.method_4570(v), uW, vH, width, height);
    }

    public static void renderSprite(class_4587 stack, class_4588 vertexBuilder, int light,
                                    int b, int g, int r, class_1058 sprite) {
        renderSprite(stack, vertexBuilder, light, b, g, r, 255, sprite);
    }

    public static void renderSprite(class_4587 stack, class_4588 vertexBuilder, int light,
                                    int b, int g, int r, int a, class_1058 sprite) {
        Matrix4f matrix4f1 = stack.method_23760().method_23761();
        float u0 = sprite.method_4580(0);
        float u1 = sprite.method_4580(1);
        float h = (u0 + u1) / 2.0f;
        float v0 = sprite.method_4570(0);
        float v1 = sprite.method_4570(1);
        float k = (v0 + v1) / 2.0f;
        float shrink = sprite.method_23842();
        float u0s = class_3532.method_16439(shrink, u0, h);
        float u1s = class_3532.method_16439(shrink, u1, h);
        float v0s = class_3532.method_16439(shrink, v0, k);
        float v1s = class_3532.method_16439(shrink, v1, k);

        vertexBuilder.method_22918(matrix4f1, -1.0F, 1.0F, 0).method_1336(r, g, b, a).method_22913(u0s, v1s).method_60803(light);
        vertexBuilder.method_22918(matrix4f1, 1.0F, 1.0F, 0).method_1336(r, g, b, a).method_22913(u1s, v1s).method_60803(light);
        vertexBuilder.method_22918(matrix4f1, 1.0F, -1.0F, 0).method_1336(r, g, b, a).method_22913(u1s, v0s).method_60803(light);
        vertexBuilder.method_22918(matrix4f1, -1.0F, -1.0F, 0).method_1336(r, g, b, a).method_22913(u0s, v0s).method_60803(light);
    }


    /**
     * Text render type that can use mipmap.
     */
    public static class_1921 getTextMipmapRenderType(class_2960 texture) {
        return MLRenderTypes.TEXT_MIP.apply(texture);
    }

    public static class_1921 getEntityCutoutMipmapRenderType(class_2960 texture) {
        return MLRenderTypes.ENTITY_CUTOUT_MIP.apply(texture);
    }

    public static class_1921 getEntitySolidMipmapRenderType(class_2960 texture) {
        return MLRenderTypes.ENTITY_SOLID_MIP.apply(texture);
    }

    /**
     * A render type that colors a texture entirely using the shader color. Just takes the shape of it into account (non transparent pixels)
     */
    public static class_1921 getColoredTextureRenderType(class_2960 texture) {
        return MLRenderTypes.COLOR_TEXT.apply(texture);
    }

    /**
     * Call at appropriate times to turn your dynamic textures into mipmapped ones. Remember to turn off
     */
    public static void setDynamicTexturesToUseMipmap(boolean mipMap) {
        MoonlightClient.setMipMap(mipMap);
    }


    public static class_1091 getStandaloneModelLocation(class_2960 location) {
        return new class_1091(location, PlatHelper.getPlatform().isFabric() ? "fabric_resource" : "standalone");
    }

}

