package net.mehvahdjukaar.moonlight.api.client.util;

import org.joml.Vector3f;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class VertexUtil {

    public static void addCube(class_4588 builder, class_4587 poseStack,
                               float width, float height, int light, int color) {
        addCube(builder, poseStack, 0, 0, width, height, light, color);
    }

    public static void addCube(class_4588 builder, class_4587 poseStack,
                               float uOff, float vOff,
                               float width, float height, int light, int color) {
        addCube(builder, poseStack, uOff, vOff,
                width, height, light, color, 1, true, true, false);
    }

    //automatic relative UV
    //invert v axis automatically
    public static void addCube(class_4588 builder, class_4587 poseStack,
                               float uOff, float vOff,
                               float w, float h, int combinedLightIn,
                               int color, float alpha,
                               boolean up, boolean down, boolean wrap) {
        addCube(builder, poseStack, uOff, 1 - (vOff + h), uOff + w, 1 - vOff, w, h, combinedLightIn, color, alpha, up, down, wrap);
    }

    public static void addCube(class_4588 builder, class_4587 poseStack,
                               float minU, float minV,
                               float maxU, float maxV,
                               float w, float h,
                               int combinedLightIn,
                               int color,
                               float alpha,
                               boolean up, boolean down, boolean wrap) {

        int lu = combinedLightIn & '\uffff';
        int lv = combinedLightIn >> 16 & '\uffff';
        float minV2 = maxV - w;

        int r = class_5253.class_5254.method_27765(color);
        int g = class_5253.class_5254.method_27766(color);
        int b = class_5253.class_5254.method_27767(color);
        int a = (int) (255 * alpha);

        float hw = w / 2f;
        float hh = h / 2f;

        float inc = 0;

        poseStack.method_22903();
        poseStack.method_46416(0, hh, 0);
        for (var d : class_2350.values()) {
            float v0 = minV;
            float t = hw;
            float y0 = -hh;
            float y1 = hh;
            float i = inc;
            if (d.method_10166() == class_2350.class_2351.field_11052) {
                if ((!up && d == class_2350.field_11036) || !down) continue;
                t = hh;
                y0 = -hw;
                y1 = hw;
                v0 = minV2;
            } else if (wrap) {
                inc += w;
            }
            poseStack.method_22903();
            poseStack.method_22907(RotHlpr.rot(d));
            poseStack.method_46416(0, 0, -t);
            addQuad(builder, poseStack, -hw, y0, hw, y1, minU + i, v0, maxU + i, maxV, r, g, b, a, lu, lv);
            poseStack.method_22909();

        }
        poseStack.method_22909();
    }

    public static void addQuad(class_4588 builder, class_4587 poseStack,
                               float x0, float y0, float x1, float y1, int lu, int lv) {
        addQuad(builder, poseStack, x0, y0, x1, y1, 255, 255, 255, 255, lu, lv);
    }

    public static void addQuad(class_4588 builder, class_4587 poseStack,
                               float x0, float y0, float x1, float y1,
                               int r, int g, int b, int a,
                               int lu, int lv) {
        addQuad(builder, poseStack, x0, y0, x1, y1, 0, 0, 1, 1, r, g, b, a, lu, lv);
    }

    //fast 2d quad. Use matrix to put where you want
    public static void addQuad(class_4588 builder, class_4587 poseStack,
                               float x0, float y0,
                               float x1, float y1,
                               float u0, float v0,
                               float u1, float v1,
                               int r, int g, int b, int a,
                               int lu, int lv) {
        class_4587.class_4665 last = poseStack.method_23760();
        Vector3f vector3f = last.method_23762().transform(new Vector3f(0, 0, -1));
        float nx = vector3f.x;
        float ny = vector3f.y;
        float nz = vector3f.z;
        //avoids having to multiply 3 times
        vertF(builder, poseStack, x0, y1, 0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
        vertF(builder, poseStack, x1, y1, 0, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        vertF(builder, poseStack, x1, y0, 0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        vertF(builder, poseStack, x0, y0, 0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void vert(class_4588 builder, class_4587 poseStack, float x, float y, float z,
                            float u, float v,
                            float r, float g, float b, float a,
                            int lu, int lv,
                            float nx, float ny, float nz) {
        //not chained because of MC263524
        builder.method_22918(poseStack.method_23760().method_23761(), x, y, z);
        builder.method_22915(r, g, b, a);
        builder.method_22913(u, v);
        builder.method_60796(0, 10);
        builder.method_22921(lu, lv);
        builder.method_60831(poseStack.method_23760(), nx, ny, nz);
    }

    private static void vertF(class_4588 builder, class_4587 poseStack,
                              float x, float y, float z,
                              float u, float v,
                              int r, int g, int b, int a,
                              int lu, int lv, float nx, float ny, float nz) {
        //not chained because of MC263524
        builder.method_22918(poseStack.method_23760().method_23761(), x, y, z);
        builder.method_1336(r, g, b, a);
        builder.method_22913(u, v);
        builder.method_60796(0, 10);
        builder.method_22921(lu, lv);
        builder.method_22914(nx, ny, nz);
    }


    //no normal rotation
    private static void vertF(class_4588 builder, class_4587 poseStack,
                              float x, float y, float z,
                              float u, float v,
                              int color,
                              int lu, int lv,
                              float nx, float ny, float nz) {
        //not chained because of MC263524
        builder.method_22918(poseStack.method_23760().method_23761(), x, y, z);
        builder.method_39415(color);
        builder.method_22913(u, v);
        builder.method_60796(0, 10);
        builder.method_22921(lu, lv);
        builder.method_22914(nx, ny, nz);
    }

    // got knows why these dont match the ones in LightTexture

    public static int lightU(int light) {
        return light & '\uffff';
    }

    public static int lightV(int light) {
        return light >> 16 & '\uffff';
    }

    private static final class_2350[] DIRS = new class_2350[]{
            class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039,
            class_2350.field_11036, class_2350.field_11033, null
    };

    public static List<class_777> getAllModelQuads(class_1087 model, class_2680 state, class_5819 rand) {
        List<class_777> allQuads = new ArrayList<>();
        for (var d : DIRS) {
            allQuads.addAll(model.method_4707(state, d, rand));
        }
        return allQuads;
    }

}
