package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_7764;

// client class
public class SoftFluidColors implements class_4013 {

    @Override
    public void method_14491(class_3300 resourceManager) {
        //also using this to reset texture cache
        RenderedTexturesManager.clearCache();

        //also using for this
        TextureCache.clear();

        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            refreshParticleColors(SoftFluidRegistry.get(level.method_30349()));
        }
    }

    public static void refreshParticleColors(class_2378<SoftFluid> reg) {
        for (var fluid : reg) {
            class_2960 location = fluid.getStillTexture();
            int averageColor = -1;

            int tint = fluid.getTintMethod().appliesToStill() ? fluid.getTintColor() : -1;

            class_1059 textureMap = class_310.method_1551().method_1554().method_24153(class_1059.field_5275);
            class_1058 sprite = textureMap.method_4608(location);
            try {
                averageColor = getAverageColor(sprite, tint);
            } catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load particle color for {} using current resource pack. might be a broken png.mcmeta", sprite);
            }
            fluid.averageTextureTint = averageColor;
        }
    }

    //credits to Random832
    @SuppressWarnings("ConstantConditions")
    private static int getAverageColor(class_1058 sprite, int tint) {
        var c = sprite.method_45851();
        if (sprite == null || c.method_45819() == 0) return -1;

        int tintR = tint >> 16 & 255;
        int tintG = tint >> 8 & 255;
        int tintB = tint & 255;
        int total = 0, totalR = 0, totalB = 0, totalG = 0;

        for (int tryFrame = 0; tryFrame < c.method_45819(); tryFrame++) {
            try {
                for (int x = 0; x < c.method_45807(); x++) {
                    for (int y = 0; y < c.method_45815(); y++) {

                        int pixel = ClientHelper.getPixelRGBA(sprite, tryFrame, x, y);

                        // this is in 0xAABBGGRR format, not the usual 0xAARRGGBB.
                        int pixelB = pixel >> 16 & 255;
                        int pixelG = pixel >> 8 & 255;
                        int pixelR = pixel & 255;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            } catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
            }
        }
        if (total <= 0) return -1;
        return class_5253.class_5254.method_27764(255,
                totalR / total * tintR / 255,
                totalG / total * tintG / 255,
                totalB / total * tintB / 255);
    }


    @ExpectPlatform
    public static int getSpecialColor(SoftFluidStack softFluidStack, class_1920 world, class_2338 pos) {
        throw new AssertionError();
    }


}
