package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;

public class AdditionalItemPlacementsAPI {

    /**
     * Adds a behavior to an existing block. can be called at any time but ideally before registration. Less ideally during mod setup
     */
    @Deprecated(forRemoval = true)
    public static void addRegistration(Consumer<Event> eventConsumer) {
        Moonlight.assertInitPhase();
        PlatHelper.addCommonSetup(() -> eventConsumer.accept(AdditionalItemPlacementsAPI::registerPlacement));
    }

    //since these need to be called on client too we MUST allow it to be called at any time so we don't need to reply on our own packet and can run on another mod will
    /***
     * Call in mod setup. Adds a placement to an item
     */
    public static void registerPlacement(class_1792 target, AdditionalItemPlacement placement) {
        IExtendedItem ei = (IExtendedItem) target;
        AdditionalItemPlacement old = ei.moonlight$getAdditionalBehavior();
        if (old != null) {
            unregisterPlacement(target);
            Moonlight.LOGGER.warn("Overriding existing additional placement behavior for item {}, placement {}", target, old);
        }
        ei.moonlight$setAdditionalBehavior(placement);
        class_2248 placedBlock = placement.getPlacedBlock();
        if (target == class_1802.field_8162 || placedBlock == class_2246.field_10124) {
            throw new AssertionError("Invalid item or block for additional placement: block = " + placedBlock + ", item = " + target);
        }

        class_1792.field_8003.put(placedBlock, target);
        placedBlock.field_17562 = null;
    }

    //shorthand
    public static void registerSimplePlacement(class_1792 target, class_2248 toPlace) {
        registerPlacement(target, new AdditionalItemPlacement(toPlace));
    }

    public static void unregisterPlacement(class_1792 target) {
        IExtendedItem ei = (IExtendedItem) target;
        AdditionalItemPlacement old = ei.moonlight$getAdditionalBehavior();
        if (old != null) {
            ei.moonlight$setAdditionalBehavior(null);
            class_2248 placedBlock = old.getPlacedBlock();
            if (placedBlock.field_17562 == target) {
                class_1792.field_8003.remove(placedBlock);
                placedBlock.field_17562 = null;
            }
        }
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(class_1792 item) {
        return ((IExtendedItem) item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(class_1792 item) {
        return getBehavior(item) != null;
    }

    @Deprecated(forRemoval = true)
    public interface Event {

        void register(class_1792 target, AdditionalItemPlacement instance);

        // Registers default instance to make simple block placement behavior
        default void registerSimple(class_1792 target, class_2248 toPlace) {
            register(target, new AdditionalItemPlacement(toPlace));
        }
    }

}
