package net.mehvahdjukaar.moonlight.api.map;

import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.core.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_7923;
import net.minecraft.class_9294;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.Locale;

import static net.mehvahdjukaar.moonlight.core.CompatHandler.MAP_ATLASES;

public class MapHelper {

    @Nullable
    public static class_22 getMapData(class_1799 stack, class_1937 level, @Nullable class_1657 player) {
        class_22 data;
        data = class_1806.method_8001(stack, level);
        if (data == null && MAP_ATLASES && player != null)
            data = MapAtlasCompat.getSavedDataFromAtlas(stack, level, player);
        return data;
    }

    /**
     * adds a vanilla decoration
     *
     * @param stack    map item stack
     * @param pos      decoration world pos
     * @param type     vanilla decorationType
     * @param mapColor map item tint color
     */
    public static void addVanillaTargetDecorationToItem(class_1799 stack, class_2338 pos, class_6880<net.minecraft.class_9428> type, int mapColor) {
        class_22.method_110(stack, pos, "+", type);
        if (mapColor != 0) {
            //custom map color overrides the deco one
            stack.method_57379(class_9334.field_49645, new class_9294(mapColor));
        }
    }

    /**
     * Adds a static decoration to a map itemstack NBT.<br>
     * Such decoration will not have any world marker associated and wont be toggleable
     *
     * @param stack    map item stack
     * @param pos      decoration world pos
     * @param type     custom decorationType
     * @param mapColor map item tint color
     */
    public static void addCustomTargetDecorationToItem(class_1799 stack, class_2338 pos, class_6880<MLMapDecorationType<?, ?>> type, int mapColor) {
        MLMapDecorationsComponent customDecoMap = stack.method_57825(MoonlightRegistry.CUSTOM_MAP_DECORATIONS.get(),
                MLMapDecorationsComponent.EMPTY);
        MLMapMarker<?> marker = new SimpleMapMarker(type, pos, 0f, Optional.empty());
        customDecoMap = customDecoMap.copyAndAdd(marker);
        stack.method_57379(MoonlightRegistry.CUSTOM_MAP_DECORATIONS.get(), customDecoMap);
        if (mapColor != 0) {
            stack.method_57379(class_9334.field_49645, new class_9294(mapColor));
        }
    }

    /**
     * see addDecorationToMap
     * This is useful when you don't have a reference to a map decoration object as it could one that has been added with datapack
     * If it fails to find the decoration type it will default to a target_x decoration
     *
     * @param id decoration type id. if invalid will default to generic structure decoration
     */
    public static void addTargetDecorationToItem(class_1937 level, class_1799 stack, class_2338 pos, class_2960 id, int mapColor) {
        var vanillaType = class_7923.field_50078.method_55841(id);
        if (vanillaType.isPresent()) {
            addVanillaTargetDecorationToItem(stack, pos, vanillaType.get(), mapColor);
            return;
        }
        var reg = MapDataRegistry.getMapDecorationRegistry(level.method_30349());
        var moddedType = reg.method_55841(id).orElse(null);
        if (moddedType != null) {
            addCustomTargetDecorationToItem(stack, pos, moddedType, mapColor);
        } else {
            addVanillaTargetDecorationToItem(stack, pos, class_21.field_84, mapColor);
        }
    }

    @Deprecated(forRemoval = true)
    public static void addTargetDecorationToItem(class_1799 stack, class_2338 pos, class_2960 id, int mapColor) {
        var vanillaType = class_7923.field_50078.method_55841(id);
        if (vanillaType.isPresent()) {
            addVanillaTargetDecorationToItem(stack, pos, vanillaType.get(), mapColor);
            return;
        }
        var moddedType = MapDataRegistry.getHolder(id);
        if (moddedType != null) {
            addCustomTargetDecorationToItem(stack, pos, moddedType, mapColor);
        } else {
            addVanillaTargetDecorationToItem(stack, pos, class_21.field_84, mapColor);
        }
    }

    /**
     * Adds all the map markers that can originate from the block at a given position
     */
    public static boolean toggleMarkersAtPos(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = getMapData(stack, level, player);
        if (data instanceof ExpandedMapData expandedMapData) {
            return expandedMapData.ml$toggleCustomDecoration(level, pos);
        }
        return false;
    }

    public static boolean removeAllCustomMarkers(class_1937 level, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = getMapData(stack, level, player);
        if (data instanceof ExpandedMapData expandedMapData) {
            if (!level.field_9236) {
                expandedMapData.ml$resetCustomDecoration();
                return true;
            }
        }
        return false;
    }

    /**
     * Helper that map decoration directly to map data using a persistent map marker. Only supports moonlight markers that have a simple marker type
     */
    public static boolean addSimpleDecorationToMap(class_22 data, class_6880<MLMapDecorationType<?, ?>> type,
                                                   class_2338 pos, float rotation, @Nullable class_2561 name) {
        //hack only works with these
        if (type.comp_349().getMarkerCodec() == SimpleMapMarker.REFERENCE_CODEC) {
            var marker = new SimpleMapMarker(type, pos, rotation, Optional.ofNullable(name));
            ((ExpandedMapData) data).ml$addCustomMarker(marker);
            return true;
        }
        return false;
    }

    /**
     * returns a list of suitable world markers associated to a position. called by mixin code
     *
     * @param reader world
     * @param pos    world position
     * @return markers found, empty list if none found
     */
    public static List<MLMapMarker<?>> getMarkersAtPos(class_1936 reader, class_2338 pos) {
        return MapDataInternal.getMarkersFromWorld(reader, pos);
    }

}
