package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

/**
 * used to add decorations for decoration types that don't have a block marker (for structure decorations for example)
 * also used for json defined ones
 */
public class SimpleMapMarker extends MLMapMarker<MLMapDecoration> {

    public static final MapCodec<SimpleMapMarker> DIRECT_CODEC = RecordCodecBuilder.mapCodec(i->
            baseCodecGroup(i).apply(i, SimpleMapMarker::new));

    public SimpleMapMarker(class_6880<MLMapDecorationType<?,?>> type, class_2338 pos, Float rotation, Optional<class_2561> name) {
        super(type, pos, rotation, name, Optional.empty(), Optional.empty(), false);

    }
    public SimpleMapMarker(class_6880<MLMapDecorationType<?,?>> type, class_2338 pos, Float rotation, Optional<class_2561> name,
                           Optional<Boolean> shouldRefresh, Optional<Boolean> shouldSave, boolean preventsExtending) {
        super(type, pos, rotation, name, shouldRefresh, shouldSave, preventsExtending);
    }

    @Override
    protected MLMapDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new MLMapDecoration(this.getType(), mapX, mapY, rot, getDisplayName());
    }




}
