package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.class_2556;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

// so hear me out, datapack registry entries are one per logical side
// this means we cant serialize them properly if we just keep 1 instance as we might want to serialize them both ways
// so we need to keep one instance per logical side
// how to do that tho? we need a way we can then retrieve with a RegistryAccess or Level
// Weak HashMap using HolderLookup.Provider as key? nope those can be subclasses and are very often, leading to more undeded instances
// so we use a dummy object from one of the registries datapack registires...
// map has weak keys so this is reload safe
public class SidedInstance<T> {

    //hack so we can have essentially an identity map
    private final Cache<class_2556, T> instances = CacheBuilder.newBuilder()
            .weakKeys()
            .build();

    private final Function<class_7225.class_7874, T> factory;

    private SidedInstance(Function<class_7225.class_7874, T> factory) {
        this.factory = factory;
    }

    public static <T> SidedInstance<T> of(Function<class_7225.class_7874, T> factory) {
        return new SidedInstance<>(factory);
    }

    public T get(class_7225.class_7874 ra) {
        try {
            return instances.get(getDummyKey(ra),
                    () -> this.factory.apply(ra));
        } catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate(class_7225.class_7874 ra) {
        class_2556 dummyKey = getDummyKey(ra);
        T instance = instances.getIfPresent(dummyKey);
        if (instance != null) {
            instances.invalidate(dummyKey);
        }
    }

    public void set(class_7225.class_7874 ra, T instance) {
        instances.put(getDummyKey(ra), instance);
    }

    private class_2556 getDummyKey(class_7225.class_7874 ra) {
        try {
            return ra.method_46762(class_7924.field_41237)
                    .method_46747(class_2556.field_11737).comp_349();
        } catch (Exception e) {
            throw new IllegalStateException("Failed to find CHAT_TYPE registry! This is a VANILLA datapack registry! How is this possible??");
        }
    }
}
