package net.mehvahdjukaar.moonlight.api.platform;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4080;
import net.minecraft.class_4538;
import net.minecraft.class_55;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * Helper class dedicated to platform forge specific methods. Usually fabric methods here just call vanilla stuff while forge have extra logic usually calling events
 */
public class ForgeHelper {

    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static <T extends class_9695> class_1860<T> copyRecipeConditions(class_1860<T> originalRecipe, class_1860<?> otherRecipe) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static <T> DynamicOps<T> addConditionOps(DynamicOps<T> ops) {
        return ops;
    }

    @ExpectPlatform
    public static <T> class_6903<T> conditionalOps(DynamicOps<T> ops, class_7225.class_7874 provider, class_4080<?> reloader) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T> Codec<Optional<T>> conditionalCodec(Codec<T> codec) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static boolean onProjectileImpact(class_1676 projectile, class_239 blockHitResult) {
        return fireOnProjectileImpact(projectile, blockHitResult);
    }

    @Contract
    @ExpectPlatform
    public static boolean fireOnProjectileImpact(class_1676 projectile, class_239 blockHitResult) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isCurativeItem(class_1799 stack, class_1293 effect) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canHarvestBlock(class_2680 state, class_3218 level, class_2338 pos, class_3222 player) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static float getFriction(class_2680 state, class_4538 level, class_2338 pos, @Nullable class_1297 entity) {
        throw new AssertionError();
    }


    @Contract
    @ExpectPlatform
    public static boolean canEquipItem(class_1309 entity, class_1799 stack, class_1304 slot) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean canEntityDestroy(class_1937 level, class_2338 blockPos, class_1429 animal) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static boolean onExplosionStart(class_1937 level, class_1927 explosion) {
        return fireOnExplosionStart(level, explosion);
    }

    @ExpectPlatform
    public static boolean fireOnExplosionStart(class_1937 level, class_1927 explosion) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void onLivingConvert(class_1309 skellyHorseMixin, class_1309 newHorse) {
        fireOnLivingConvert(skellyHorseMixin, newHorse);
    }

    @ExpectPlatform
    public static void fireOnLivingConvert(class_1309 frFom, class_1309 to) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canLivingConvert(class_1309 entity, class_1299<? extends class_1309> outcome, Consumer<Integer> timer) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void onExplosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> entities, double diameter) {
        fireOnExplosionDetonate(level, explosion, entities, diameter);
    }

    @ExpectPlatform
    public static void fireOnExplosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> entities, double diameter) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static float getExplosionResistance(class_2680 state, class_1937 level, class_2338 pos, class_1927 explosion) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void onBlockExploded(class_2680 blockstate, class_1937 level, class_2338 blockpos, class_1927 explosion) {
        fireOnBlockExploded(blockstate, level, blockpos, explosion);
    }

    @ExpectPlatform
    public static void fireOnBlockExploded(class_2680 blockstate, class_1937 level, class_2338 blockpos, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean canDropFromExplosion(class_2680 blockstate, class_1937 level, class_2338 blockpos, class_1927 explosion) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isDye(class_1799 itemstack) {
        throw new AssertionError();
    }

    @org.jetbrains.annotations.Nullable
    @ExpectPlatform
    public static class_1767 getColor(class_1799 stack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2680 rotateBlock(class_2680 state, class_1937 world, class_2338 targetPos, class_2470 rot) {
        throw new AssertionError();
    }


    @Contract
    @ExpectPlatform
    public static boolean isMultipartEntity(class_1297 e) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void setPoolName(class_55.class_56 pool, String name) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2768 getRailDirection(class_2241 railBlock, class_2680 blockstate, class_1937 level, class_2338 blockpos, @org.jetbrains.annotations.Nullable class_1688 o) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Optional<class_1799> getCraftingRemainingItem(class_1799 itemstack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void reviveEntity(class_1297 entity) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static boolean onCropsGrowPre(class_3218 level, class_2338 pos, class_2680 state, boolean b) {
        return fireOnCropsGrowPre(level, pos, state, b);
    }

    @ExpectPlatform
    public static boolean fireOnCropsGrowPre(class_3218 level, class_2338 pos, class_2680 state, boolean b) {
        throw new AssertionError();

    }

    @Deprecated(forRemoval = true)
    public static void onCropsGrowPost(class_3218 level, class_2338 pos, class_2680 state) {
        fireOnCropsGrowPost(level, pos, state);
    }

    @ExpectPlatform
    public static void fireOnCropsGrowPost(class_3218 level, class_2338 pos, class_2680 state) {
        throw new AssertionError();
    }

    public static void onEquipmentChange(class_1309 entity, class_1304 slot, class_1799 from, class_1799 to) {
        fireOnEquipmentChange(entity, slot, from, to);
    }

    @ExpectPlatform
    public static void fireOnEquipmentChange(class_1309 entity, class_1304 slot, class_1799 from, class_1799 to) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static class_1269 onRightClickBlock(class_1657 player, class_1268 hand, class_2338 below, class_3965 rayTraceResult) {
        return fireOnRightClickBlock(player, hand, below, rayTraceResult);
    }

    @ExpectPlatform
    @Nullable
    public static class_1269 fireOnRightClickBlock(class_1657 player, class_1268 hand, class_2338 below, class_3965 rayTraceResult) {
        throw new AssertionError();
    }


    @ExpectPlatform
    public static int getLightEmission(class_2680 state, class_1937 level, class_2338 pos) {
        throw new ArrayStoreException();
    }

    @ExpectPlatform
    public static Map<class_2248, class_1792> getBlockItemMap() {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean isInFluidThatCanExtinguish(class_1297 entity) {
        throw new AssertionError();
    }


    @ExpectPlatform
    public static void registerDefaultContainerCap(class_2591<? extends class_1263> container) {

    }
}
