/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.IDebugDumpable;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public abstract class DynamicResourcesProvider
implements SimplePackProvider {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final class_2960 name;
    private final class_9224 locationInfo;
    private final class_3264 packType;
    protected final IEditablePackResources packResources;
    protected final PackGenerationStrategy generationStrategy;
    private volatile boolean needsRegeneration = true;

    public DynamicResourcesProvider(class_2960 name, class_3264 packType, PackGenerationStrategy generationPolicy) {
        this.name = name;
        this.packType = packType;
        this.generationStrategy = generationPolicy;
        this.locationInfo = new class_9224(name.toString(), (class_2561)class_2561.method_43471((String)LangBuilder.getReadableName(name.toString())), class_5352.field_25348, Optional.empty());
        this.packResources = generationPolicy.createPackResources(this.locationInfo, packType);
        this.packResources.addNamespaces(this.gatherSupportedNamespaces().toArray(new String[0]));
        this.packResources.addNamespaces(name.method_12836());
    }

    public IEditablePackResources getPackResources() {
        return this.packResources;
    }

    public class_2960 getName() {
        return this.name;
    }

    public class_9224 getLocationInfo() {
        return this.locationInfo;
    }

    public class_3264 getPackType() {
        return this.packType;
    }

    public class_9225 createSelectionConfig() {
        return new class_9225(true, class_3288.class_3289.field_14280, false);
    }

    public String toString() {
        return "Dynamic " + String.valueOf(this.getPackType()) + " Resources Provider [" + String.valueOf(this.name) + "]";
    }

    public final void prepare() {
        this.needsRegeneration = this.needsToRegenerate();
    }

    public boolean needsToRegenerate() {
        boolean shouldRegenDueToInvalid;
        if (this.generationStrategy.needsRegeneration(this.packType)) {
            return this.packResources.clearAllResources();
        }
        boolean bl = shouldRegenDueToInvalid = !this.packResources.initializeIfValid();
        if (shouldRegenDueToInvalid) {
            Moonlight.LOGGER.info("Cache for {} at {} is invalid, will regenerate", (Object)this, (Object)this.packResources);
        }
        return shouldRegenDueToInvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(class_3300 manager, IProgressTracker reporter) {
        if (this.needsRegeneration) {
            this.needsRegeneration = false;
            try {
                Moonlight.LOGGER.info("Regenerating {}, requested by strategy {}", (Object)this, (Object)this.generationStrategy);
                Stopwatch watch = Stopwatch.createStarted();
                this.runGenerationPipeline(manager, reporter);
                Moonlight.LOGGER.info("Generated runtime {} for pack {} in {}", (Object)this.getPackType(), (Object)this.packResources.method_14409(), (Object)watch);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}", (Object)this, (Object)e);
            }
            finally {
                IEditablePackResources iEditablePackResources;
                this.packResources.commitChanges();
                if (this.generateDebugResources() && (iEditablePackResources = this.packResources) instanceof IDebugDumpable) {
                    IDebugDumpable d = (IDebugDumpable)((Object)iEditablePackResources);
                    this.getExecutorService().execute(() -> d.dumpToDisk(Paths.get("debug", "generated_resource_pack")));
                }
            }
        } else {
            Moonlight.LOGGER.info("Skipping regeneration for {} (cache up-to-date)", (Object)this);
        }
    }

    private void runGenerationPipeline(class_3300 manager, IProgressTracker progressTracker) {
        ArrayList genTasks = new ArrayList();
        try {
            this.regenerateDynamicAssets(genTasks::add);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to add tasks to dynamic resource gen: ", (Throwable)e);
        }
        int totalTasks = genTasks.size();
        IProgressTracker.Task reporter = progressTracker.subtask(totalTasks);
        List<CompletableFuture> futures = genTasks.stream().map(task -> CompletableFuture.supplyAsync(() -> {
            ResourceSink sink = new ResourceSink(this.name.method_12836(), this.packResources.method_14409());
            task.accept(manager, sink);
            return sink;
        }, this.getExecutorService()).handle((sink, ex) -> {
            reporter.step();
            if (ex != null) {
                Moonlight.LOGGER.error("Resource Gen Task failed", ex);
                return null;
            }
            return sink;
        })).toList();
        List<ResourceSink> successful = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).toList();
        if (successful.isEmpty()) {
            Moonlight.LOGGER.warn("No resource sinks produced; all tasks failed or none were scheduled.");
            return;
        }
        try {
            ResourceSink.acceptSinks(this.packResources, successful);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to accept generated resource sinks", (Throwable)e);
        }
    }

    protected Executor getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    protected boolean generateDebugResources() {
        return PlatHelper.isDev();
    }

    protected abstract Collection<String> gatherSupportedNamespaces();

    public void addSupportedNamespaces(String ... namespace) {
        this.packResources.addNamespaces(namespace);
    }

    protected abstract void regenerateDynamicAssets(Consumer<ResourceGenTask> var1);

    @Override
    public class_3288 createPack() {
        final IEditablePackResources resources = this.packResources;
        return class_3288.method_45275((class_9224)this.getLocationInfo(), (class_3288.class_7680)new class_3288.class_7680(){

            public class_3262 method_52424(class_9224 location) {
                return resources;
            }

            public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                return resources;
            }
        }, (class_3264)this.getPackType(), (class_9225)this.createSelectionConfig());
    }
}

