/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.misc.OptHolderRef;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import org.jetbrains.annotations.ApiStatus;

public class HolderRef<T> {
    private final class_5321<class_2378<T>> registryKey;
    private final class_5321<T> key;
    private final WeakHashMap<class_7225.class_7874, class_6880<T>> cache = new WeakHashMap();
    private static final WeakHashSet<HolderRef<?>> REFERENCES = new WeakHashSet();

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(HolderRef::invalidateCache);
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    protected HolderRef(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> HolderRef<A> wrap(A obj, class_5321<class_2378<A>> registry) {
        return HolderRef.of(Utils.getID(obj), registry);
    }

    public static <A> HolderRef<A> of(String id, class_5321<class_2378<A>> registry) {
        return HolderRef.of(class_2960.method_12829((String)id), registry);
    }

    public static <A> HolderRef<A> of(class_2960 location, class_5321<class_2378<A>> registry) {
        return new HolderRef<A>(registry, class_5321.method_29179(registry, (class_2960)location));
    }

    public static <A> HolderRef<A> of(class_5321<A> key) {
        return new HolderRef<A>(class_5321.method_29180((class_2960)key.method_41185()), key);
    }

    public static <A> OptHolderRef<A> optional(class_2960 location, class_5321<class_2378<A>> registry) {
        return new OptHolderRef<A>(registry, class_5321.method_29179(registry, (class_2960)location));
    }

    public static <A> OptHolderRef<A> optional(class_5321<A> key) {
        return new OptHolderRef<A>(class_5321.method_29180((class_2960)key.method_41185()), key);
    }

    public T get(class_1297 entity) {
        return this.get(entity.method_37908());
    }

    public T get(class_1937 level) {
        return this.get((class_7225.class_7874)level.method_30349());
    }

    public T get(class_4538 level) {
        return this.get((class_7225.class_7874)level.method_30349());
    }

    public T get(class_7225.class_7874 r) {
        return (T)this.getHolder(r).comp_349();
    }

    public boolean is(T object, class_7225.class_7874 r) {
        return this.getHolder(r).comp_349() == object;
    }

    public boolean is(T object, class_4538 level) {
        return this.is(object, (class_7225.class_7874)level.method_30349());
    }

    public boolean is(class_6862<T> tag, class_7225.class_7874 r) {
        return this.getHolder(r).method_40220(tag);
    }

    public boolean is(class_6862<T> tag, class_4538 level) {
        return this.is(tag, (class_7225.class_7874)level.method_30349());
    }

    public class_6880<T> getHolder(class_1297 entity) {
        return this.getHolder(entity.method_37908());
    }

    public class_6880<T> getHolder(class_1937 level) {
        return this.getHolder((class_7225.class_7874)level.method_30349());
    }

    public class_6880<T> getHolder(class_4538 level) {
        return this.getHolder((class_7225.class_7874)level.method_30349());
    }

    public class_6880<T> getHolder(class_7225.class_7874 r) {
        class_6880<T> holder = this.cache.get(r);
        if (holder != null) {
            return holder;
        }
        Optional lookupReg = r.method_46759(this.registryKey);
        class_7225.class_7226 reg = (class_7225.class_7226)lookupReg.get();
        holder = this.lookup((class_7871<T>)reg);
        this.cache.put(r, holder);
        return holder;
    }

    public class_6880<T> lookup(class_7871<T> lookup) {
        try {
            return lookup.method_46747(this.key);
        }
        catch (Exception e) {
            Object extra = "";
            if (lookup instanceof class_7225) {
                class_7225 l = (class_7225)lookup;
                extra = ".\nRegistry content was: " + String.valueOf(l.method_42017().map(b -> b.method_40237().method_29177()).toList());
            }
            throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\n" + (String)extra);
        }
    }

    public String getRegisteredName() {
        return this.key.method_29177().toString();
    }

    public class_2960 getID() {
        return this.key.method_29177();
    }

    public class_5321<T> getKey() {
        return this.key;
    }

    public boolean is(class_2960 location) {
        return this.registryKey.method_29177().equals((Object)location);
    }

    public boolean is(class_5321<T> resourceKey) {
        return resourceKey == this.key;
    }

    public boolean is(Predicate<class_5321<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(class_6880<T> other) {
        return other.method_40230().get() == this.key;
    }

    public String toString() {
        return "DynamicHolder{" + String.valueOf(this.key) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HolderRef)) {
            return false;
        }
        HolderRef that = (HolderRef)o;
        return Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.registryKey, this.key);
    }

    @Deprecated(forRemoval=true)
    public static class Opt<T>
    extends OptHolderRef<T> {
        protected Opt(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
            super(registryKey, key);
        }
    }
}

