/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.LenientHolderSetCodec;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.mehvahdjukaar.moonlight.api.util.fabric.UtilsImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2985;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3908;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6899;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8779;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Codec<class_238> AABB_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_243.field_38277.fieldOf("from").forGetter(class_238::method_61125), (App)class_243.field_38277.fieldOf("to").forGetter(class_238::method_61126)).apply((Applicative)i, class_238::new));

    public static boolean openGuiIfPossible(class_2586 be, class_3222 player, class_1799 stack, class_2350 hitFace) {
        IOneUserInteractable ci;
        class_2338 pos = be.method_11016();
        if (!Utils.mayPerformBlockAction((class_1657)player, pos, stack)) {
            return false;
        }
        if (be instanceof IOneUserInteractable && !(ci = (IOneUserInteractable)be).canBeUsedBy(pos, (class_1297)player)) {
            return false;
        }
        if (be instanceof IScreenProvider) {
            IScreenProvider sp = (IScreenProvider)be;
            if (be instanceof IOneUserInteractable) {
                IOneUserInteractable ci2 = (IOneUserInteractable)be;
                ci2.setCurrentUser(player.method_5667());
            }
            sp.sendOpenGuiPacket(player, hitFace);
            return false;
        }
        if (be instanceof class_3908) {
            class_3908 mp = (class_3908)be;
            if (be instanceof IOneUserInteractable) {
                IOneUserInteractable ci3 = (IOneUserInteractable)be;
                ci3.setCurrentUser(player.method_5667());
            }
            TileOrEntityTarget target = TileOrEntityTarget.of(be);
            PlatHelper.openCustomMenu(player, mp, target::write);
            return true;
        }
        return false;
    }

    public static void spawnItemWithTileData(class_1657 player, class_2621 tile) {
        class_1937 level = player.method_37908();
        if (!level.field_9236 && player.method_7337() && !tile.method_5442()) {
            class_2338 pos = tile.method_11016();
            class_1799 itemstack = Utils.saveTileToItem((class_2586)tile);
            class_1542 itementity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemstack);
            itementity.method_6988();
            level.method_8649((class_1297)itementity);
        } else {
            tile.method_54873(player);
        }
    }

    public static class_1799 saveTileToItem(class_2586 tile) {
        class_2248 block = tile.method_11010().method_26204();
        class_1799 stack = new class_1799((class_1935)block.method_8389());
        tile.method_38240(stack, (class_7225.class_7874)tile.method_10997().method_30349());
        return stack;
    }

    public static void loadTileFromItem(class_2586 tile, class_1799 stack) {
        class_9279 comp = (class_9279)stack.method_57824(class_9334.field_49611);
        if (comp != null) {
            tile.method_58690(comp.method_57461(), (class_7225.class_7874)tile.method_10997().method_30349());
        }
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem, boolean bothSides) {
        if (!player.method_37908().field_9236 || bothSides) {
            player.method_6122(hand, class_5328.method_30270((class_1799)oldItem.method_7972(), (class_1657)player, (class_1799)newItem, (boolean)player.method_7337()));
        }
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        Utils.swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        if (!player.method_37908().field_9236) {
            player.method_6122(hand, class_5328.method_30270((class_1799)oldItem.method_7972(), (class_1657)player, (class_1799)newItem, (boolean)false));
        }
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 newItem) {
        Utils.swapItem(player, hand, player.method_5998(hand), newItem);
    }

    @Deprecated(forRemoval=true)
    public static void addStackToExisting(class_1657 player, class_1799 stack, boolean avoidEmptyHands) {
        Utils.addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(class_1268.field_5808) : InvPlacer.handOrExistingOrAny(class_1268.field_5808));
    }

    public static void addItemOrDrop(class_1657 player, class_1799 stack, InvPlacer placer) {
        class_1661 inv = player.method_31548();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(class_1657 player, class_1799 stack) {
        Utils.addItemOrDrop(player, stack, InvPlacer.existingOrAny());
    }

    public static int getXPinaBottle(int bottleCount, class_5819 rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.method_43048(5) + rand.method_43048(5);
        }
        return xp;
    }

    public static class_2960 getId(class_6880<?> object) {
        return ((class_5321)object.method_40230().get()).method_29177();
    }

    public static class_2960 getID(@NotNull class_2248 object) {
        return class_7923.field_41175.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_1299<?> object) {
        return class_7923.field_41177.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1959 object) {
        return Utils.hackyGetRegistry(class_7924.field_41236).method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_8110 type) {
        return Utils.hackyGetRegistry(class_7924.field_42534).method_10221((Object)type);
    }

    public static class_2960 getID(@NotNull class_2975<?, ?> object) {
        return Utils.hackyGetRegistry(class_7924.field_41239).method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1792 object) {
        return class_7923.field_41178.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_3611 object) {
        return class_7923.field_41173.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_2591<?> object) {
        return class_7923.field_41181.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1865<?> object) {
        return class_7923.field_41189.method_10221(object);
    }

    @Deprecated(forRemoval=true)
    public static class_2960 getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().method_10221((Object)object);
    }

    @Deprecated(forRemoval=true)
    public static class_2960 getID(@NotNull MLMapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1842 object) {
        return class_7923.field_41179.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_1291 object) {
        return class_7923.field_41174.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_1761 object) {
        return class_7923.field_44687.method_10221((Object)object);
    }

    public static class_2960 getID(@NotNull class_3448<?> object) {
        return class_7923.field_41193.method_10221(object);
    }

    public static class_2960 getID(@NotNull Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2248.class, class_1792.class, class_1299.class, class_2591.class, class_1959.class, class_3611.class, class_1865.class, class_2975.class, class_1842.class, class_1291.class, Supplier.class, SoftFluid.class, MLMapDecorationType.class, class_1761.class, class_8110.class, class_3448.class, class_6880.class}, (Object)object3, n)) {
            case 0 -> {
                class_2248 b = (class_2248)object3;
                yield Utils.getID(b);
            }
            case 1 -> {
                class_1792 b = (class_1792)object3;
                yield Utils.getID(b);
            }
            case 2 -> {
                class_1299 b = (class_1299)object3;
                yield Utils.getID(b);
            }
            case 3 -> {
                class_2591 b = (class_2591)object3;
                yield Utils.getID(b);
            }
            case 4 -> {
                class_1959 b = (class_1959)object3;
                yield Utils.getID(b);
            }
            case 5 -> {
                class_3611 b = (class_3611)object3;
                yield Utils.getID(b);
            }
            case 6 -> {
                class_1865 b = (class_1865)object3;
                yield Utils.getID(b);
            }
            case 7 -> {
                class_2975 c = (class_2975)object3;
                yield Utils.getID(c);
            }
            case 8 -> {
                class_1842 c = (class_1842)object3;
                yield Utils.getID(c);
            }
            case 9 -> {
                class_1291 c = (class_1291)object3;
                yield Utils.getID(c);
            }
            case 10 -> {
                Supplier s = (Supplier)object3;
                yield Utils.getID(s.get());
            }
            case 11 -> {
                SoftFluid s = (SoftFluid)object3;
                yield Utils.getID(s);
            }
            case 12 -> {
                MLMapDecorationType s = (MLMapDecorationType)object3;
                yield Utils.getID(s);
            }
            case 13 -> {
                class_1761 t = (class_1761)object3;
                yield Utils.getID(t);
            }
            case 14 -> {
                class_8110 t = (class_8110)object3;
                yield Utils.getID(t);
            }
            case 15 -> {
                class_3448 t = (class_3448)object3;
                yield Utils.getID(t);
            }
            case 16 -> {
                class_6880 h = (class_6880)object3;
                yield Utils.getId(h);
            }
            default -> throw new UnsupportedOperationException("Unsupported class type " + String.valueOf(object.getClass()) + ". Expected a registry entry for a call to Utils.getID()");
        };
    }

    @Deprecated(forRemoval=true)
    public static <T> boolean isTagged(T entry, class_2378<T> registry, class_6862<T> tag) {
        return registry.method_47983(entry).method_40220(tag);
    }

    public static <T> class_7225.class_7226<T> hackyFindRegistryOf(class_6880<T> holder, class_5321<class_2378<T>> registryKey) {
        class_5455.class_6890 serverRa;
        class_5455 clientRa;
        class_2378 r;
        class_638 level;
        if (holder instanceof class_6880.class_6883) {
            class_6880.class_6883 ref = (class_6880.class_6883)holder;
            class_7876 class_78762 = ref.field_40930;
            if (class_78762 instanceof class_7225.class_7226) {
                class_7225.class_7226 ra = (class_7225.class_7226)class_78762;
                return ra;
            }
        }
        if (PlatHelper.getPhysicalSide().isClient() && (level = class_310.method_1551().field_1687) != null && holder.method_46745((r = (clientRa = level.method_30349()).method_30530(registryKey)).method_46770())) {
            return clientRa.method_46762(registryKey);
        }
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (s != null && holder.method_46745((r = (serverRa = s.method_30611()).method_30530(registryKey)).method_46770())) {
            return serverRa.method_46762(registryKey);
        }
        throw new UnsupportedOperationException("Failed to find registry access for " + String.valueOf(holder));
    }

    public static class_5455 hackyGetRegistryAccess() {
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.method_18854() || !MoonlightClient.isClientThread())) {
                return s.method_30611();
            }
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                return level.method_30349();
            }
            WeakReference<class_5455> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) {
                return (class_5455)hack2.get();
            }
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) {
            return s.method_30611();
        }
        WeakReference<class_5455> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) {
            return (class_5455)hack2.get();
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> class_2378<T> hackyGetRegistry(class_5321<class_2378<T>> key) {
        return Utils.hackyGetRegistryAccess().method_30530(key);
    }

    public static class_4970.class_2251 copyPropertySafe(class_2248 blockBehaviour) {
        class_4970.class_2251 p = class_4970.class_2251.method_9630((class_4970)blockBehaviour);
        class_2680 state = blockBehaviour.method_9564();
        p.method_9631(s -> state.method_26213());
        p.method_49229(class_4970.class_2250.field_10656);
        p.method_26235((blockState, blockGetter, pos, entityType) -> blockState.method_26206(blockGetter, pos, class_2350.field_11036) && blockState.method_26213() < 14);
        p.method_31710(blockBehaviour.method_26403());
        p.method_26249((blockState, blockGetter, blockPos) -> false);
        return p;
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name) {
        Utils.awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name, String unlockProp) {
        class_2985 advancements;
        class_8779 advancement = sp.method_5682().method_3851().method_12896(name);
        if (advancement != null && !(advancements = sp.method_14236()).method_12882(advancement).method_740()) {
            advancements.method_12878(advancement, unlockProp);
        }
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, class_5558<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, Consumer<A> tickFunc) {
        return targetType == type ? (level, blockPos, blockState, blockEntity) -> tickFunc.accept(blockEntity) : null;
    }

    public static class_2680 readBlockState(class_2487 compound, @Nullable class_1937 level) {
        class_7225.class_7226 holderGetter = level != null ? level.method_45448(class_7924.field_41254) : class_7923.field_41175.method_46771();
        return class_2512.method_10681((class_7871)holderGetter, (class_2487)compound);
    }

    public static <T extends Comparable<T>, A extends class_2769<T>> class_2680 replaceProperty(class_2680 from, class_2680 to, A property) {
        if (from.method_28498(property)) {
            return (class_2680)to.method_11657(property, from.method_11654(property));
        }
        return to;
    }

    public static boolean mayPerformBlockAction(class_1657 player, class_2338 pos, class_1799 stack) {
        boolean result;
        class_1934 gameMode;
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            gameMode = sp.field_13974.method_14257();
        } else {
            gameMode = class_310.method_1551().field_1761.method_2920();
        }
        boolean bl = result = !player.method_21701(player.method_37908(), pos, gameMode);
        if (!result && gameMode == class_1934.field_9216 && !stack.method_7960() && stack.method_57357(new class_2694((class_4538)player.method_37908(), pos, false))) {
            return true;
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = Utils.findMethodWithMatchingName(subclass, name);
        Method modMethod = Utils.findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static <A> MapCodec<A> safeOptFieldOf(Codec<A> c, String name, Supplier<A> defaultValue) {
        return Codec.optionalField((String)name, c, (boolean)false).xmap(o -> o.orElse(defaultValue.get()), a -> Objects.equals(a, defaultValue.get()) ? Optional.empty() : Optional.of(a));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        void var1_1;
        return UtilsImpl.optionalMapCodec(keyCodec, var1_1);
    }

    public static <T> Codec<T> optionalRegistryCodec(class_2378<T> reg, T defaultValue) {
        return class_2960.field_25139.xmap(rl -> {
            Object value = reg.method_10223(rl);
            return value == null ? defaultValue : value;
        }, arg_0 -> reg.method_10221(arg_0));
    }

    public static <T> Codec<List<T>> optionalRegistryListCodec(class_2378<T> reg) {
        return class_2960.field_25139.listOf().xmap(l -> l.stream().filter(arg_0 -> ((class_2378)reg).method_10250(arg_0)).map(arg_0 -> ((class_2378)reg).method_10223(arg_0)).toList(), a -> a.stream().map(arg_0 -> ((class_2378)reg).method_10221(arg_0)).toList());
    }

    public static <A> LenientListCodec<A> lenientListCodec(Codec<A> elementCodec) {
        return new LenientListCodec<A>(elementCodec);
    }

    public static <E> Codec<class_6885<E>> lenientHomogeneousList(class_5321<? extends class_2378<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, class_6899.method_40400(registryKey), false);
    }

    public static <T extends Enum<T>> class_9139<class_2540, T> enumStreamCodec(Class<T> enumClass) {
        return new EnumStreamCodec<T>(enumClass);
    }

    public static class_2960 idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return class_2960.method_60654((String)id);
        }
        return class_2960.method_60655((String)namespace, (String)id);
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, class_2960 ... ids) {
        for (class_2960 r : ids) {
            Optional optional = registry.method_17966(r);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, Iterable<class_2960> ids) {
        for (class_2960 r : ids) {
            Optional optional = registry.method_17966(r);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    private record EnumStreamCodec<T extends Enum<T>>(Class<T> enumClass) implements class_9139<class_2540, T>
    {
        public T decode(class_2540 buf) {
            return (T)buf.method_10818(this.enumClass);
        }

        public void encode(class_2540 buf, T e) {
            buf.method_10817(e);
        }
    }
}

