/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class HolderReference<T> {
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    private final WeakHashMap<HolderLookup.Provider, Holder<T>> cache = new WeakHashMap();
    private static final WeakHashSet<HolderReference<?>> REFERENCES = new WeakHashSet();

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(HolderReference::invalidateCache);
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    protected HolderReference(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> HolderReference<A> of(String id, ResourceKey<Registry<A>> registry) {
        return HolderReference.of(ResourceLocation.tryParse((String)id), registry);
    }

    public static <A> HolderReference<A> of(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new HolderReference<A>(registry, ResourceKey.create(registry, (ResourceLocation)location));
    }

    public static <A> HolderReference<A> of(ResourceKey<A> key) {
        return new HolderReference<A>(ResourceKey.createRegistryKey((ResourceLocation)key.registry()), key);
    }

    public static <A> Opt<A> optional(ResourceKey<A> key) {
        return new Opt<A>(ResourceKey.createRegistryKey((ResourceLocation)key.registry()), key);
    }

    @Deprecated(forRemoval=true)
    public T getUnsafe() {
        return this.get((HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    }

    public T get(Entity entity) {
        return this.get(entity.level());
    }

    public T get(Level level) {
        return this.get((HolderLookup.Provider)level.registryAccess());
    }

    public T get(HolderLookup.Provider r) {
        return (T)this.getHolder(r).value();
    }

    @Deprecated(forRemoval=true)
    public Holder<T> getHolderUnsafe() {
        return this.getHolder((HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    }

    public Holder<T> getHolder(Entity entity) {
        return this.getHolder(entity.level());
    }

    public Holder<T> getHolder(Level level) {
        return this.getHolder((HolderLookup.Provider)level.registryAccess());
    }

    public Holder<T> getHolder(HolderLookup.Provider r) {
        Holder<T> holder = this.cache.get(r);
        if (holder != null) {
            return holder;
        }
        Optional lookupReg = r.lookup(this.registryKey);
        HolderLookup.RegistryLookup reg = (HolderLookup.RegistryLookup)lookupReg.get();
        holder = this.lookup((HolderGetter<T>)reg);
        this.cache.put(r, holder);
        return holder;
    }

    public Holder<T> lookup(HolderGetter<T> lookup) {
        try {
            return lookup.getOrThrow(this.key);
        }
        catch (Exception e) {
            Object extra = "";
            if (lookup instanceof HolderLookup) {
                HolderLookup l = (HolderLookup)lookup;
                extra = ".\nRegistry content was: " + String.valueOf(l.listElements().map(b -> b.key().location()).toList());
            }
            throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\n" + (String)extra);
        }
    }

    public String getRegisteredName() {
        return this.key.location().toString();
    }

    public ResourceLocation getID() {
        return this.key.location();
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public boolean is(ResourceLocation location) {
        return this.registryKey.location().equals((Object)location);
    }

    public boolean is(ResourceKey<T> resourceKey) {
        return resourceKey == this.key;
    }

    public boolean is(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(Holder<T> other) {
        return other.unwrapKey().get() == this.key;
    }

    public String toString() {
        return "DynamicHolder{" + String.valueOf(this.key) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HolderReference)) {
            return false;
        }
        HolderReference that = (HolderReference)o;
        return Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.registryKey, this.key);
    }

    public static class Opt<T>
    extends HolderReference<T> {
        protected Opt(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
            super(registryKey, key);
        }

        public boolean isPresent(HolderLookup.Provider r) {
            return this.getHolder(r) != null;
        }

        public Optional<Holder<T>> asOptionalHolder(HolderLookup.Provider r) {
            return Optional.ofNullable(this.getHolder(r));
        }

        public Optional<T> asOptional(HolderLookup.Provider r) {
            return Optional.ofNullable(this.get(r));
        }

        @Override
        @Nullable
        public T get(HolderLookup.Provider r) {
            Holder h = super.getHolder(r);
            return (T)(h != null ? h.value() : null);
        }

        @Override
        @Nullable
        public T get(Level level) {
            return super.get(level);
        }

        @Override
        @Nullable
        public T get(Entity entity) {
            return super.get(entity);
        }

        @Override
        @Nullable
        public T getUnsafe() {
            return super.getUnsafe();
        }

        @Override
        @Nullable
        public Holder<T> getHolder(HolderLookup.Provider r) {
            return super.getHolder(r);
        }

        @Override
        @Nullable
        public Holder<T> getHolder(Level level) {
            return super.getHolder(level);
        }

        @Override
        @Deprecated(forRemoval=true)
        @Nullable
        public Holder<T> getHolderUnsafe() {
            return super.getHolderUnsafe();
        }

        @Override
        @Nullable
        public Holder<T> getHolder(Entity entity) {
            return super.getHolder(entity);
        }

        @Override
        @Nullable
        public Holder<T> lookup(HolderGetter<T> lookup) {
            try {
                return super.lookup(lookup);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

