/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.CachePathPackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import org.jetbrains.annotations.NotNull;

public class GlobalCachedStrategy
implements PackGenerationStrategy {
    private static final Map<PackType, Boolean> NEEDS_REGEN = new HashMap<PackType, Boolean>();
    private static final Map<PackType, String> LAST_KNOWN_HASH = new HashMap<PackType, String>();

    public static void refreshState(PackType packType, Collection<PackResources> loadedPacks) {
        String newHash;
        String oldHash = GlobalCachedStrategy.readFingerprint(packType);
        boolean shouldRegen = !oldHash.equals(newHash = GlobalCachedStrategy.computeCurrentFingerprint(loadedPacks));
        Moonlight.LOGGER.info("Resource cache state for {}: {}", (Object)packType, (Object)(shouldRegen ? "needs regeneration" : "up to date"));
        NEEDS_REGEN.put(packType, shouldRegen);
        LAST_KNOWN_HASH.put(packType, newHash);
    }

    public static void writeNewState(PackType packType) {
        String newHash = LAST_KNOWN_HASH.get(packType);
        if (newHash != null) {
            GlobalCachedStrategy.writeFingerprint(packType, newHash);
            NEEDS_REGEN.put(packType, false);
        }
    }

    private static void writeFingerprint(PackType packType, String fp) {
        Path dir = GlobalCachedStrategy.getCachePath(packType);
        Path file = GlobalCachedStrategy.getCacheHashPath(packType);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)fp, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            Moonlight.LOGGER.debug("Failed writing cache fingerprint for {}: {}", (Object)packType, (Object)e.toString());
        }
    }

    private static String readFingerprint(PackType packType) {
        Path file = GlobalCachedStrategy.getCacheHashPath(packType);
        if (!Files.exists(file, new LinkOption[0])) {
            return "";
        }
        try {
            return Files.readString(file, StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            Moonlight.LOGGER.debug("Failed reading cache fingerprint for {}: {}", (Object)packType, (Object)e.toString());
            return "";
        }
    }

    private static Path getCacheHashPath(PackType packType) {
        return GlobalCachedStrategy.getCachePath(packType).resolve("hash.txt");
    }

    private static Path getCachePath(PackType type) {
        return PlatHelper.getGamePath().resolve("dynamic-" + (type == PackType.CLIENT_RESOURCES ? "resource" : "data") + "-pack-cache");
    }

    private static String computeCurrentFingerprint(Collection<PackResources> packs) {
        return MthUtils.sha256Digest(GlobalCachedStrategy.computeTokens(packs));
    }

    @NotNull
    private static List<String> computeTokens(Collection<PackResources> packs) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean fabric = PlatHelper.getPlatform().isFabric();
        int i = 0;
        for (PackResources p : packs) {
            String id = p.packId();
            if (DynamicResourcesInternals.isKnownDynamicPack(p.location().id()) || id.startsWith("mod/") || fabric && id.startsWith("fabric") || id.startsWith("generated")) continue;
            String description = "";
            try {
                PackMetadataSection metadataSection = (PackMetadataSection)p.getMetadataSection((MetadataSectionSerializer)PackMetadataSection.TYPE);
                if (metadataSection != null) {
                    description = metadataSection.description().getString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            tokens.add("pack[" + i++ + "]=" + id + "@" + description);
        }
        ArrayList<CallSite> modTokens = new ArrayList<CallSite>();
        for (String mod : PlatHelper.getInstalledMods()) {
            if (fabric && mod.startsWith("fabric")) continue;
            modTokens.add((CallSite)((Object)(mod + "@" + PlatHelper.getModVersion(mod))));
        }
        Collections.sort(modTokens);
        tokens.addAll(modTokens);
        return tokens;
    }

    @Override
    public boolean needsRegeneration(PackType packType) {
        return NEEDS_REGEN.get(packType);
    }

    protected Path getPath(PackType type) {
        return GlobalCachedStrategy.getCachePath(type);
    }

    @Override
    public IEditablePackResources createPackResources(PackLocationInfo info, PackType type) {
        return new CachePathPackResources(info, type, this.getPath(type).resolve(info.id().replace(":", "-")));
    }

    public String toString() {
        return "CACHED";
    }
}

