/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class StaticResource {
    public final byte[] data;
    public final class_2960 location;
    public final String sourceName;
    private String dataAsString = null;

    private StaticResource(byte[] data, class_2960 location, String sourceName) {
        this.data = data;
        this.location = location;
        this.sourceName = sourceName;
    }

    public static StaticResource of(class_3298 original, class_2960 location) {
        byte[] data1 = new byte[]{};
        try (InputStream stream = original.method_14482();){
            try {
                data1 = stream.readAllBytes();
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Could not parse resource: {}", (Object)location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StaticResource(data1, location, original.method_14480());
    }

    public static StaticResource create(byte[] data, class_2960 location) {
        return new StaticResource(data, location, location.toString());
    }

    @Nullable
    public static StaticResource getOrLog(class_3300 manager, class_2960 location) {
        try {
            return StaticResource.of((class_3298)manager.method_14486(location).get(), location);
        }
        catch (Exception var4) {
            Moonlight.LOGGER.error("Could not find resource {}", (Object)location);
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    public static StaticResource getOrFail(class_3300 manager, class_2960 location) throws NoSuchElementException {
        return StaticResource.of((class_3298)manager.method_14486(location).orElseThrow(), location);
    }

    public static StaticResource getOrThrow(class_3300 manager, class_2960 location) throws NoSuchElementException {
        return StaticResource.of((class_3298)manager.method_14486(location).orElseThrow(), location);
    }

    public JsonObject toJson() {
        JsonObject jsonObject;
        ByteArrayInputStream s = new ByteArrayInputStream(this.data);
        try {
            jsonObject = RPUtils.deserializeJson(s);
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        s.close();
        return jsonObject;
    }

    public String asString() {
        if (this.dataAsString == null) {
            this.dataAsString = new String(this.data, StandardCharsets.UTF_8);
        }
        return this.dataAsString;
    }
}

