/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FastSearchPathPackResources
extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;
    private final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    private final class_3264 packType;

    public FastSearchPathPackResources(class_9224 location, Path root, class_3264 packType) {
        super(location);
        this.root = root;
        this.packType = packType;
        this.buildIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex() {
        Stopwatch watch = Stopwatch.createStarted();
        Path base = this.root.resolve(this.packType.method_14413());
        if (!Files.exists(base, new LinkOption[0])) {
            Moonlight.LOGGER.info("Pack at {} does not contain {}, skipping index", (Object)this.root, (Object)this.packType.method_14413());
            return;
        }
        try (Stream<Path> stream = Files.find(base, Integer.MAX_VALUE, (p, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);){
            stream.forEach(file -> {
                String rel = base.relativize((Path)file).toString().replace('\\', '/');
                int slash = rel.indexOf(47);
                if (slash <= 0 || slash == rel.length() - 1) {
                    return;
                }
                String namespace = rel.substring(0, slash);
                String pathWithinNs = rel.substring(slash + 1);
                if (!class_2960.method_20209((String)namespace)) {
                    LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.root);
                    return;
                }
                class_2960 rl = class_2960.method_43902((String)namespace, (String)pathWithinNs);
                if (rl != null) {
                    this.searchTrie.insert(rl);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to build index for {}", (Object)base, (Object)e);
        }
        finally {
            Moonlight.LOGGER.info("Populated search tree for pack at {} in {}", (Object)this.root, (Object)watch);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        class_4239.method_46345((String[])elements);
        Path path = class_4239.method_46344((Path)this.root, List.of(elements));
        return Files.exists(path, new LinkOption[0]) ? class_7367.create((Path)path) : null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        if (this.packType != packType) {
            return null;
        }
        Path path = this.root.resolve(packType.method_14413()).resolve(location.method_12836());
        return FastSearchPathPackResources.getResource(location, path);
    }

    @Nullable
    public static class_7367<InputStream> getResource(class_2960 location, Path path) {
        return (class_7367)class_4239.method_46346((String)location.method_12832()).mapOrElse(list -> {
            Path path2 = class_4239.method_46344((Path)path, (List)list);
            return FastSearchPathPackResources.returnFileIfExists(path2);
        }, error -> {
            LOGGER.error("Invalid path {}: {}", (Object)location, (Object)error.message());
            return null;
        });
    }

    @Nullable
    private static class_7367<InputStream> returnFileIfExists(Path path) {
        return Files.exists(path, new LinkOption[0]) ? class_7367.create((Path)path) : null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 output) {
        if (packType != this.packType) {
            return;
        }
        this.searchTrie.search(namespace + "/" + path).forEach(resourceLocation -> {
            Path file = this.root.resolve(packType.method_14413()).resolve(resourceLocation.method_12836()).resolve(resourceLocation.method_12832());
            if (Files.isRegularFile(file, new LinkOption[0])) {
                output.accept(resourceLocation, (Object)class_7367.create((Path)file));
            } else {
                LOGGER.warn("File not found or not regular: {} -> {}", resourceLocation, (Object)file);
            }
        });
    }

    public Set<String> method_14406(class_3264 packType) {
        if (packType != this.packType) {
            return Set.of();
        }
        return new HashSet<String>(this.searchTrie.listFolders(""));
    }

    public void close() {
    }
}

