package net.mehvahdjukaar.moonlight.api.block;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public interface IRotatable {
    /**
     * returns the block state rotated over an axis. Do not use this to actually rotate the block. use rotateOverAxis or onRotated instead
     * @param state original block state
     * @param world world
     * @param pos position
     * @param rotation rotation
     * @param axis rotation axis
     * @return rotated state. Optional.empty() if block hasn't been rotated. you can return the same blockstate for tile entities that have other meaning of rotation
     */
    Optional<class_2680> getRotatedState(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation,
                               class_2350 axis, @Nullable class_243 hit);
    /**
     * actually rotates the block. Overrides if you need more control over what rotating actually means
     * @param state original block state
     * @param world world
     * @param pos position
     * @param rotation rotation
     * @param axis rotation axis
     * @return the direction onto which the block was actually rotated. Optional.empty() if it wasn't rotated at all
     */
    default Optional<class_2350> rotateOverAxis(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation,
                                   class_2350 axis, @Nullable class_243 hit){

        Optional<class_2680> optional = this.getRotatedState(state, world, pos,rotation,axis, hit);
        if (optional.isPresent()) {
            class_2680 rotated = optional.get();

            if (rotated.method_26184(world, pos)) {
                rotated = class_2248.method_9510(rotated, world, pos);

                if (world instanceof class_3218) {
                    world.method_8652(pos, rotated, 11);
                    //level.updateNeighborsAtExceptFromFacing(pos, newState.getBlock(), mydir.getOpposite());
                }
                this.onRotated(rotated, state, world, pos, rotation, axis, hit);
                return Optional.of(axis);
            }
        }
        return Optional.empty();
    }

    /**
     * performs extra actions after it has been rotated
     * @param newState blockstate
     * @param oldState old blockstate
     * @param axis axis of rotation
     */
    default void onRotated(class_2680 newState, class_2680 oldState, class_1936 world, class_2338 pos, class_2470 rotation,
                                         class_2350 axis, @Nullable class_243 hit){
    }




}
