package net.mehvahdjukaar.moonlight.api.block;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5712;

public abstract class ItemDisplayTile extends class_2621 implements class_1278, IOwnerProtected {
    @Nullable
    private UUID owner = null;
    private class_2371<class_1799> stacks;

    protected ItemDisplayTile(class_2591 type, class_2338 pos, class_2680 state) {
        this(type, pos, state, 1);
    }

    protected ItemDisplayTile(class_2591 type, class_2338 pos, class_2680 state, int slots) {
        super(type, pos, state);
        this.stacks = class_2371.method_10213(slots, class_1799.field_8037);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return owner;
    }

    //should only be server side. called when inventory has changed
    @Override
    public void method_5431() {
        if (this.field_11863 == null || field_11863.field_9236) return;
        this.updateTileOnInventoryChanged();
        if (this.needsToUpdateClientWhenChanged()) {
            //this saves and sends a packet to update the client tile
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), class_2248.field_31028);
        }
        super.method_5431();
    }

    /**
     * called every time the tile is marked dirty or loaded. Server side method.
     * Put here common logic for things that needs to react to inventory changes like updating blockState or logic
     */
    public void updateTileOnInventoryChanged() {
    }

    /**
     * @return true if the tile needs to react one inventory changes on client.
     * Set to true if you are using updateClientVisualsOnLoad()
     * usually not needed for tiles that do not visually display their content
     */
    public boolean needsToUpdateClientWhenChanged() {
        return true;
    }

    /**
     * Called after the tile is loaded from packet. Client side.
     * Put here client only visual logic that needs to react to inventory changes
     */
    public void updateClientVisualsOnLoad() {
    }

    public class_1799 getDisplayedItem() {
        return this.method_5438(0);
    }

    public void setDisplayedItem(class_1799 stack) {
        this.method_5447(0, stack);
    }

    public class_1269 interact(class_1657 player, class_1268 handIn) {
        return this.interact(player, handIn, 0);
    }

    public class_1269 interact(class_1657 player, class_1268 handIn, int slot) {
        if (!this.isAccessibleBy(player)) {
            player.method_7353(class_2561.method_43469("container.isLocked", ""), true);
        } else if (handIn == class_1268.field_5808) {
            class_1799 handItem = player.method_5998(handIn);
            //remove
            if (handItem.method_7960()) {
                class_1799 it = this.method_5441(slot);
                if (!it.method_7960()) {
                    onItemRemoved(player, it, slot);
                    if (!this.field_11863.method_8608()) {
                        player.method_6122(handIn, it);
                        this.method_5431();
                    } else {
                        //also update visuals on client. will get overwritten by packet tho
                        this.updateClientVisualsOnLoad();
                    }
                    return class_1269.method_29236(this.field_11863.field_9236);
                }
            }
            //place
            else if (!handItem.method_7960() && this.method_5437(slot, handItem)) {
                class_1799 it = handItem.method_7972();
                it.method_7939(1);
                this.method_5447(slot, it);

                if (!player.method_7337()) {
                    handItem.method_7934(1);
                }
                onItemAdded(player, it, slot);
                if (!this.field_11863.method_8608()) {
                    this.field_11863.method_8396(null, this.field_11867, this.getAddItemSound(), class_3419.field_15245, 1.0F, this.field_11863.field_9229.method_43057() * 0.10F + 0.95F);
                    //this.setChanged();
                } else {
                    //also update visuals on client. will get overwritten by packet tho
                    this.updateClientVisualsOnLoad();
                }
                return class_1269.method_29236(this.field_11863.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public void onItemRemoved(class_1657 player, class_1799 stack, int slot) {
        field_11863.method_43276(class_5712.field_28733, field_11867, class_5712.class_7397.method_43286(player, method_11010()));
    }

    public void onItemAdded(class_1657 player, class_1799 stack, int slot) {
        field_11863.method_43276(class_5712.field_28733, field_11867, class_5712.class_7397.method_43286(player, method_11010()));

        //server
        if (player instanceof class_3222 serverPlayer) {
            class_174.field_24478.method_23889(serverPlayer, field_11867, stack);
            player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
        }
    }

    public class_3414 getAddItemSound() {
        return class_3417.field_14667;
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (!this.method_11283(compound)) {
            this.stacks = class_2371.method_10213(this.method_5439(), class_1799.field_8037);
        }
        class_1262.method_5429(compound, this.stacks);
        if (this.field_11863 != null) {
            if (this.field_11863.field_9236) this.updateClientVisualsOnLoad();
                //this doesn't work on first load cause world is null on server. You need to save stuff on nbt
            else this.updateTileOnInventoryChanged();
        }
        this.loadOwner(compound);
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (!this.method_11286(compound)) {
            class_1262.method_5426(compound, this.stacks);
        }
        this.saveOwner(compound);
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public int method_5439() {
        return stacks.size();
    }

    @Override
    public int method_5444() {
        return 1;
    }

    //use the one below
    @Deprecated(forRemoval = true)
    @ApiStatus.Internal
    @Override
    public class_1703 method_5465(int id, class_1661 player) {
        return class_1707.method_19245(id, player, this);
    }

    @Nullable
    @Override
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }


    @Override
    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    @Override
    public void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return this.method_5442();
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }


}