package net.mehvahdjukaar.moonlight.api.block;


import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_8567;
import java.util.List;

public abstract class MimicBlock extends class_2248 {
    protected MimicBlock(class_2251 properties) {
        super(properties.method_26249(MimicBlock::hasEmissiveRendering));
    }

    private static boolean hasEmissiveRendering(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        if (blockGetter.method_8321(pos) instanceof IBlockHolder tile) {
            class_2680 mimic = tile.getHeldBlock();
            return mimic.method_26208(blockGetter, pos);
        }
        return false;
    }


    //THIS IS DANGEROUS
    @Override
    public float method_9594(class_2680 state, class_1657 player, class_1922 worldIn, class_2338 pos) {
        if (worldIn.method_8321(pos) instanceof IBlockHolder tile) {
            class_2680 mimicState = tile.getHeldBlock();
            //prevent infinite recursion
            if (!mimicState.method_26215() && !(mimicState.method_26204() instanceof MimicBlock))
                return Math.min(super.method_9594(state, player, worldIn, pos),
                        mimicState.method_26165(player, worldIn, pos));
        }
        return super.method_9594(state, player, worldIn, pos);
    }

    //might cause lag when breaking?
//@Override
    @PlatformOnly(PlatformOnly.FORGE)
    public class_2498 getSoundType(class_2680 state, class_4538 world, class_2338 pos, class_1297 entity) {
        if (world.method_8321(pos) instanceof IBlockHolder tile) {
            class_2680 mimicState = tile.getHeldBlock();
            if (!mimicState.method_26215()) return mimicState.method_26231();
        }
        return super.method_9573(state);
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List<class_1799> drops = super.method_9560(state, builder);
        if (builder.method_51876(class_181.field_1228) instanceof IBlockHolder tile) {
            //checks again if the content itself can be mined
            class_2680 heldState = tile.getHeldBlock();
            if (builder.method_51876(class_181.field_1226) instanceof class_3222 player) {
                if (!ForgeHelper.canHarvestBlock(heldState, builder.method_51870(),
                        class_2338.method_49638(builder.method_51873(class_181.field_24424)), player)) {
                    return drops;
                }
            }
            List<class_1799> newDrops = heldState.method_26189(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    @Override
    public boolean method_9516(class_2680 state, class_1922 worldIn, class_2338 pos, class_10 type) {
        return false;
    }

    //@Override
    @PlatformOnly(PlatformOnly.FORGE)
    public float getExplosionResistance(class_2680 state, class_1922 world, class_2338 pos, class_1927 explosion) {
        if (world.method_8321(pos) instanceof IBlockHolder tile) {
            class_2680 mimicState = tile.getHeldBlock();
            if (!mimicState.method_26215() && !(mimicState.method_26204() instanceof MimicBlock)) {
                return Math.max(ForgeHelper.getExplosionResistance(mimicState, (class_1937) world, pos, explosion),
                        state.method_26204().method_9520());
            }
        }
        return 2;
    }

    @Override
    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        if (level.method_8321(pos) instanceof IBlockHolder tile) {
            class_2680 mimic = tile.getHeldBlock();
            return mimic.method_26204().method_9574(level, pos, state);
        }
        return super.method_9574(level, pos, state);
    }


}
