package net.mehvahdjukaar.moonlight.api.block;

import com.google.common.collect.Lists;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2404;
import net.minecraft.class_3609;
import net.minecraft.class_3612;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;

public class ModLiquidBlock extends class_2404 {

    private static Field FORGE_BLOCK_SUPPLIER;
    private static Field INIT;

    public ModLiquidBlock(Supplier<? extends class_3609> supplier, class_2251 arg) {
        super(PlatHelper.getPlatform().isFabric() ? supplier.get() : class_3612.field_15910, arg);
        if (PlatHelper.getPlatform().isForge()) {
            if (FORGE_BLOCK_SUPPLIER == null) FORGE_BLOCK_SUPPLIER = PlatHelper.findField(class_2404.class, "supplier");
            if (INIT == null) INIT = PlatHelper.findField(class_2404.class, "fluidStateCacheInitialized");
            try {
                for(var f : class_2404.class.getDeclaredFields()){
                    if(f.getType() == class_3609.class){
                        f.setAccessible(true);
                        f.set(this, null);
                    }else if(f.getType() == ArrayList.class){
                        f.setAccessible(true);
                        f.set(this, Lists.newArrayList());
                    }
                }
                INIT.setAccessible(true);
                INIT.set(this, false);
                this.method_9590(this.field_10647.method_11664().method_11657(field_11278, 0));
                FORGE_BLOCK_SUPPLIER.setAccessible(true);
                FORGE_BLOCK_SUPPLIER.set(this, supplier);
                INIT.set(this, false);
            } catch (Exception e) {
                Moonlight.LOGGER.error("Failed to setup ModLiquidBlock class : "+e);
                throw new RuntimeException(e);
            }
        }

    }
}
