package net.mehvahdjukaar.moonlight.api.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundOpenScreenPacket;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3222;

/**
 * Implement in your blocks or tiles. Just for utility method
 */
public interface IScreenProvider {

    @Deprecated(forRemoval = true)
    @Environment(EnvType.CLIENT)
    void openScreen(class_1937 level, class_2338 pos, class_1657 player);

    @Environment(EnvType.CLIENT)
    default void openScreen(class_1937 level, class_2338 pos, class_1657 player, class_2350 direction){
        openScreen(level, pos, player);
    }

    default void sendOpenGuiPacket(class_1937 level, class_2338 pos, class_1657 player) {
        sendOpenGuiPacket(level, pos, player, class_2350.field_11043);
    }

    default void sendOpenGuiPacket(class_1937 level, class_2338 pos, class_1657 player, class_2350 hitFace) {
        ModMessages.CHANNEL.sendToClientPlayer((class_3222) player,
                new ClientBoundOpenScreenPacket(pos, hitFace));
    }
}
