package net.mehvahdjukaar.moonlight.api.client.model;

import dev.architectury.injectables.annotations.ExpectPlatform;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.util.function.Consumer;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_4588;
import net.minecraft.class_4590;
import net.minecraft.class_777;

/**
 * Cross loader utility to create baked quad
 * On forge just wraps its own baked quad builder. Can also be fed to render calls as it implements vertex consumer
 */
public interface BakedQuadBuilder extends class_4588 {

    static BakedQuadBuilder create(class_1058 sprite) {
        return create(sprite, (Matrix4f) null);
    }

    static BakedQuadBuilder create(class_1058 sprite, @Nullable class_4590 transformation) {
        return create(sprite, transformation == null ? null : new Matrix4f().translate(0.5f, 0.5f, 0.5f)
                .mul(transformation.method_22936())
                .translate(-0.5f, -0.5f, -0.5f));
    }

    //
    @ExpectPlatform
    static BakedQuadBuilder create(class_1058 sprite, @Nullable Matrix4f transformation) {
        throw new AssertionError();
    }


    BakedQuadBuilder setAutoDirection();

    BakedQuadBuilder setDirection(class_2350 direction);

    BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion);

    BakedQuadBuilder setShade(boolean shade);

    BakedQuadBuilder lightEmission(int light);

    @Deprecated(forRemoval = true)
    BakedQuadBuilder fromVanilla(class_777 quad);

    BakedQuadBuilder setTint(int tintIndex);

    class_777 build();

    BakedQuadBuilder setAutoBuild(Consumer<class_777> quadConsumer);


    @Override
    default BakedQuadBuilder method_22918(Matrix4f matrix, float x, float y, float z) {
        class_4588.super.method_22918(matrix, x, y, z);
        return this;
    }

    @Override
    default BakedQuadBuilder method_23763(Matrix3f matrix, float x, float y, float z) {
        class_4588.super.method_23763(matrix, x, y, z);
        return this;
    }
}
