package net.mehvahdjukaar.moonlight.api.client.model;

import dev.architectury.injectables.annotations.ExpectPlatform;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1058;
import net.minecraft.class_777;

/**
 * Utility object to transform existing bake quads
 * on Forge just wraps its own QuadTransformers class
 */
public interface BakedQuadsTransformer {

    @ExpectPlatform
    static BakedQuadsTransformer create() {
        throw new AssertionError();
    }

    default List<class_777> transformAll(List<class_777> quads) {
        List<class_777> list = new ArrayList<>();
        quads.forEach(q -> list.add(transform(q)));
        return list;
    }

    class_777 transform(class_777 quad);

    BakedQuadsTransformer applyingAmbientOcclusion(boolean ambientOcclusion);

    BakedQuadsTransformer applyingEmissivity(int emissivity);

    BakedQuadsTransformer applyingLightMap(int packedLight);

    BakedQuadsTransformer applyingShade(boolean shade);

    BakedQuadsTransformer applyingTintIndex(int tintIndex);

    BakedQuadsTransformer applyingTransform(Matrix4f transform);

    default BakedQuadsTransformer applyingColor(int ABGRcolor) {
        applyingColor(i -> ABGRcolor);
        return this;
    }

    BakedQuadsTransformer applyingColor(IntUnaryOperator indexToABGR);

    BakedQuadsTransformer applyingSprite(class_1058 sprite);


}
