package net.mehvahdjukaar.moonlight.api.client.model;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public interface CustomBakedModel extends class_1087 {

    /**
     * Main implementation
     * render type is null when we do block breaking animation
     */
    List<class_777> getBlockQuads(class_2680 state, class_2350 direction, class_5819 randomSource,
                                  @Nullable class_1921 renderType, ExtraModelData extraModelData);

    class_1058 getBlockParticle(ExtraModelData extraModelData);

    // do not implement
    @ApiStatus.Internal
    @Override
    default List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        return List.of();
    }

    @Override
    default class_1058 method_4711() {
        return getBlockParticle(ExtraModelData.EMPTY);
    }

    /**
     * you can override this method to get the data of your block.
     * By default, the implementation just grabs it from the tile entity at pos if it implements IExtraModelDataProvider
     */
    default ExtraModelData getModelData(@NotNull ExtraModelData tileData, class_2338 pos, class_2680 state, class_1920 level) {
        return tileData;
    }

    default ExtraModelData getModelData(@NotNull ExtraModelData originalData, class_1799 stack) {
        return originalData;
    }
}
