package net.mehvahdjukaar.moonlight.api.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.client.resources.model.*;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * Simple implementation of a dynamic model that accepts another model as a parameter
 */
public class NestedModelLoader implements CustomModelLoader {

    private final BiFunction<class_1087, class_3665, CustomBakedModel> factory;
    private final String path;

    @Deprecated(forRemoval = true)
    public NestedModelLoader(String modelPath, Function<class_1087, CustomBakedModel> bakedModelFactory) {
        this(modelPath, (a, b) -> bakedModelFactory.apply(a));
    }

    public NestedModelLoader(String modelPath, BiFunction<class_1087, class_3665, CustomBakedModel> bakedModelFactory) {
        this.factory = bakedModelFactory;
        this.path = modelPath;
    }

    @Override
    public CustomGeometry deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        var j = json.get(path);
        return (modelBaker, spriteGetter, transform, location) -> {

            var baked = CustomModelLoader.parseModel(j, modelBaker, spriteGetter, transform, location);
            return factory.apply(baked, transform);
        };
    }


    // helper function you'll likely only need here
    @Deprecated(forRemoval = true)
   public static class_1087 parseModel(JsonElement j, class_7775 modelBaker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_2960 location) {
        class_793 model;
        if (j.isJsonPrimitive()) {
            model = (class_793) modelBaker.method_45872(class_2960.method_12829(j.getAsString()));
        } else {
            model = ClientHelper.parseBlockModel(j);
        }
        model.method_45785(modelBaker::method_45872);
        if (model == modelBaker.method_45872(class_1088.field_5374)) {
            throw new JsonParseException("Found missing model while parsing nested model " + location);
        }
        return model.method_3446(modelBaker, model, spriteGetter, transform, location, true);
    }
}