package net.mehvahdjukaar.moonlight.api.client.renderer;

import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;

/**
 * A tile entity that is able to switch off and on its tile renderer based on distance from the camera
 * Should be used with a dynamic baked model that can react to the change in the extra model data to render with or without TESR
 */
@Deprecated(forRemoval = true)
public abstract class DynamicRenderedBlockTile extends class_2586 implements IExtraModelDataProvider {

    public static final ModelDataKey<Boolean> IS_FANCY = new ModelDataKey<>(Boolean.class);

    // lod stuff (client)
    private boolean isFancy = false; // current
    private int extraFancyTicks = 0;

    protected DynamicRenderedBlockTile(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(IS_FANCY, this.isFancy);
    }

    // Can be hooked on some configs to turn off the fancy renderer
    public abstract boolean isNeverFancy();

    public void onFancyChanged(boolean fancy) {
    }

    // use if you need this info in your tile anywhere. Shouldn't be needed in TESR
    public boolean rendersFancy() {
        return isFancy;
    }

    /**
     * Must be called in your TESR shouldRender method.
     *
     * @return true if the block should render with TESR
     */
    public boolean shouldRenderFancy(class_243 cameraPos) {
        if (isNeverFancy()) return false;

        boolean newFancyStatus = getFancyDistance(cameraPos);
        boolean oldStatus = this.isFancy;
        if (oldStatus != newFancyStatus) {
            this.isFancy = newFancyStatus;
            onFancyChanged(isFancy);
            if (this.field_11863 == class_310.method_1551().field_1687) {
                this.requestModelReload();
                this.field_11863.method_8413(this.field_11867, method_11010(), method_11010(), class_2248.field_31030);
            }
            if (!isFancy) extraFancyTicks = 4;
        }
        if (extraFancyTicks > 0) {
            extraFancyTicks--;
            return true;
        }
        // 1 tick delay
        return isFancy;
    }

    protected boolean getFancyDistance(class_243 cameraPos) {
        LOD lod = new LOD(cameraPos, this.method_11016());
        return lod.isNear();
    }

}
