package net.mehvahdjukaar.moonlight.api.client.util;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_7833;

public class RotHlpr {
    //TODO: merge with math helper
    //dont modify these pls. these are mutable unforunately posestack doesnt accept Quaternionfc
    public static final Quaternionf Y180 = class_7833.field_40716.rotationDegrees(180);
    public static final Quaternionf Y90 = class_7833.field_40716.rotationDegrees(90);
    public static final Quaternionf Y45 = class_7833.field_40716.rotationDegrees(45);
    public static final Quaternionf YN45 = class_7833.field_40716.rotationDegrees(-45);
    public static final Quaternionf YN90 = class_7833.field_40716.rotationDegrees(-90);
    public static final Quaternionf YN180 = class_7833.field_40716.rotationDegrees(-180);

    public static final Quaternionf X180 = class_7833.field_40714.rotationDegrees(180);
    public static final Quaternionf X90 = class_7833.field_40714.rotationDegrees(90);
    public static final Quaternionf X22 = class_7833.field_40714.rotationDegrees(22.5f);
    public static final Quaternionf XN22 = class_7833.field_40714.rotationDegrees(-22.5f);
    public static final Quaternionf XN90 = class_7833.field_40714.rotationDegrees(-90);
    public static final Quaternionf XN180 = class_7833.field_40714.rotationDegrees(-180);

    public static final Quaternionf Z180 = class_7833.field_40718.rotationDegrees(180);
    public static final Quaternionf Z135 = class_7833.field_40718.rotationDegrees(135);
    public static final Quaternionf Z90 = class_7833.field_40718.rotationDegrees(90);
    public static final Quaternionf ZN45 = class_7833.field_40718.rotationDegrees(-45);
    public static final Quaternionf ZN90 = class_7833.field_40718.rotationDegrees(-90);
    public static final Quaternionf ZN180 = class_7833.field_40718.rotationDegrees(-180);

    private static final Map<class_2350, Quaternionf> DIR2ROT = Maps.newEnumMap(Arrays.stream(class_2350.values())
            .collect(Collectors.toMap(Functions.identity(), d -> d.method_10153().method_23224().mul(XN90))));

    private static final Map<Integer, Quaternionf> YAW2ROT = Arrays.stream(class_2350.values()).filter(d -> d.method_10166() != class_2350.class_2351.field_11052)
            .map(d -> (int) -d.method_10144()).collect(Collectors.toMap(Functions.identity(), y -> class_7833.field_40716.rotationDegrees(y)));

    //relative to north facing
    public static Quaternionf rot(class_2350 dir) {
        return DIR2ROT.get(dir);
    }

    private static final Quaternionf def = class_7833.field_40716.rotationDegrees(0);

    public static Quaternionf rot(int rot) {
        return YAW2ROT.getOrDefault(rot, def);
    }

    @Deprecated(forRemoval = true)
    public static Vector3f rotateVertexOnCenterBy(float x, float y, float z, Matrix4f pTransform) {
        Vector3f v = new Vector3f(x, y, z);
        rotateVertexBy(v, new Vector3f(0.5F, 0.5F, 0.5F), pTransform);
        return v;
    }

    @Deprecated(forRemoval = true)
    public static void rotateVertexBy(Vector3f pPos, Vector3f pOrigin, Matrix4f pTransform) {
        Vector4f vector4f = new Vector4f(pPos.x() - pOrigin.x(), pPos.y() - pOrigin.y(), pPos.z() - pOrigin.z(), 1.0F);
        vector4f.mul(pTransform);
        pPos.set(vector4f.x() + pOrigin.x(), vector4f.y() + pOrigin.y(), vector4f.z() + pOrigin.z());
    }

    @Deprecated(forRemoval = true)
    public static class_2350 rotateDirection(class_2350 direction, Matrix4f transform) {
        var d = direction.method_10163();
        var normal = new Vector3f(d.method_10263(), d.method_10264(), d.method_10260());
        RotHlpr.rotateVertexBy(normal, new Vector3f(), transform);
        return class_2350.method_10147(normal.x(), normal.y(), normal.z());
    }

}