package net.mehvahdjukaar.moonlight.api.entity;

import com.google.common.collect.ImmutableList;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1646;
import net.minecraft.class_4140;
import java.util.function.Consumer;

//TODO: rename
public class VillagerAIHooks {

    /**
     * Register an event listener for the villager brain event.
     * On forge Use the subscribe event annotation instead
     */
    public static void addBrainModification(Consumer<IVillagerBrainEvent> eventConsumer){
        MoonlightEventsHelper.addListener(eventConsumer, IVillagerBrainEvent.class);
    }

    /**
     * Adds a memory module to the villager brain when it's created.
     * Add here and not in the event if that memory needs to be saved,
     * otherwise it will not be loaded since the event is called after the brain is deserialized from tag
     */
    public static void registerMemory(class_4140<?> memoryModuleType) {

        try {
            ImmutableList.Builder<class_4140<?>> builder = ImmutableList.builder();
            builder.addAll( class_1646.field_18538);
            builder.add(memoryModuleType);
            class_1646.field_18538 = (builder.build());

        } catch (Exception e) {
            Moonlight.LOGGER.warn("failed to register memory module type for villagers: " + e);
        }
    }

}
